# This script was automatically generated from the dsa-1209
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that Trac, a wiki and issue tracking system for
software development projects, performs insufficient validation against
cross-site request forgery, which might lead to an attacker being able
to perform manipulation of a Trac site with the privileges of the
attacked Trac user.
For the stable distribution (sarge) this problem has been fixed in
version 0.8.1-3sarge7.
For the unstable distribution (sid) this problem has been fixed in
version 0.10.1-1.
We recommend that you upgrade your trac package.


Solution : http://www.debian.org/security/2006/dsa-1209
Risk factor : High';

if (description) {
 script_id(23658);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1209");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1209] DSA-1209-2 trac");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1209-2 trac");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'trac', release: '3.1', reference: '0.8.1-3sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package trac is vulnerable in Debian 3.1.\nUpgrade to trac_0.8.1-3sarge7\n');
}
if (deb_check(prefix: 'trac', release: '3.1', reference: '0.8.1-3sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package trac is vulnerable in Debian sarge.\nUpgrade to trac_0.8.1-3sarge7\n');
}
if (w) { security_hole(port: 0, data: desc); }
