# This script was automatically generated from the dsa-1212
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Two denial of service problems have been found in the OpenSSH
server. The Common Vulnerabilities and Exposures project identifies the
following vulnerabilities:
    The sshd support for ssh protocol version 1 does not properly
    handle duplicate incoming blocks. This could allow a remote
    attacker to cause sshd to consume significant CPU resources
    leading to a denial of service.
    A signal handler race condition could potentially allow a remote
    attacker to crash sshd and could theoretically lead to the
    ability to execute arbitrary code.
For the stable distribution (sarge), these problems have been fixed in
version 1:3.8.1p1-8.sarge.6.
For the unstable and testing distributions, these problems have been
fixed in version 1:4.3p2-4.
We recommend that you upgrade your openssh package.


Solution : http://www.debian.org/security/2006/dsa-1212
Risk factor : High';

if (description) {
 script_id(23661);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1212");
 script_cve_id("CVE-2006-4924", "CVE-2006-5051");
 script_bugtraq_id(20216, 20241);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1212] DSA-1212-1 openssh");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1212-1 openssh");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'ssh', release: '3.1', reference: '3.8.1p1-8.sarge.6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ssh is vulnerable in Debian 3.1.\nUpgrade to ssh_3.8.1p1-8.sarge.6\n');
}
if (deb_check(prefix: 'ssh-askpass-gnome', release: '3.1', reference: '3.8.1p1-8.sarge.6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ssh-askpass-gnome is vulnerable in Debian 3.1.\nUpgrade to ssh-askpass-gnome_3.8.1p1-8.sarge.6\n');
}
if (deb_check(prefix: 'openssh', release: '3.1', reference: '3.8.1p1-8.sarge.6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openssh is vulnerable in Debian sarge.\nUpgrade to openssh_3.8.1p1-8.sarge.6\n');
}
if (w) { security_hole(port: 0, data: desc); }
