# This script was automatically generated from the dsa-1214
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The original update provided in DSA 1214-1 was insufficient; this update
corrects this. For reference please find the original advisory text below:

Renaud Lifchitz discovered that gv, the PostScript and PDF viewer for X,
performs insufficient boundary checks in the Postscript parsing code,
which allows the execution of arbitrary code through a buffer overflow.
For the stable distribution (sarge) this problem has been fixed in
version 3.6.1-10sarge2.
For the upcoming stable distribution (etch) this problem has been
fixed in version 3.6.2-2.
For the unstable distribution (sid) this problem has been fixed in
version 3.6.2-2.
We recommend that you upgrade your gv package.


Solution : http://www.debian.org/security/2006/dsa-1214
Risk factor : High';

if (description) {
 script_id(23700);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1214");
 script_cve_id("CVE-2006-5864");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1214] DSA-1214-2 gv");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1214-2 gv");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gv', release: '3.1', reference: '3.6.1-10sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gv is vulnerable in Debian 3.1.\nUpgrade to gv_3.6.1-10sarge2\n');
}
if (deb_check(prefix: 'gv', release: '4.0', reference: '3.6.2-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gv is vulnerable in Debian etch.\nUpgrade to gv_3.6.2-2\n');
}
if (deb_check(prefix: 'gv', release: '3.1', reference: '3.6.1-10sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gv is vulnerable in Debian sarge.\nUpgrade to gv_3.6.1-10sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
