# This script was automatically generated from the dsa-1215
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Xine multimedia
library, which may lead to the execution of arbitrary code. The Common
Vulnerabilities and Exposures project identifies the following problems:
    The XFocus Security Team discovered that insufficient validation of
    AVI headers may lead to the execution of arbitrary code.
    Michael Niedermayer discovered that a buffer overflow in the 4XM
    codec may lead to the execution of arbitrary code.
For the stable distribution (sarge) these problems have been fixed in
version 1.0.1-1sarge4.
For the upcoming stable distribution (etch) these problems have been
fixed in version 1.1.2-1.
For the unstable distribution (sid) these problems have been fixed in
version 1.1.2-1.
We recommend that you upgrade your xine-lib packages.


Solution : http://www.debian.org/security/2006/dsa-1215
Risk factor : High';

if (description) {
 script_id(23701);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1215");
 script_cve_id("CVE-2006-4799", "CVE-2006-4800");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1215] DSA-1215-1 xine-lib");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1215-1 xine-lib");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libxine-dev', release: '3.1', reference: '1.0.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine-dev is vulnerable in Debian 3.1.\nUpgrade to libxine-dev_1.0.1-1sarge4\n');
}
if (deb_check(prefix: 'libxine1', release: '3.1', reference: '1.0.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libxine1 is vulnerable in Debian 3.1.\nUpgrade to libxine1_1.0.1-1sarge4\n');
}
if (deb_check(prefix: 'xine-lib', release: '4.0', reference: '1.1.2-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xine-lib is vulnerable in Debian etch.\nUpgrade to xine-lib_1.1.2-1\n');
}
if (deb_check(prefix: 'xine-lib', release: '3.1', reference: '1.0.1-1sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xine-lib is vulnerable in Debian sarge.\nUpgrade to xine-lib_1.0.1-1sarge4\n');
}
if (w) { security_hole(port: 0, data: desc); }
