# This script was automatically generated from the dsa-1216
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Eric Romang discovered that the flexbackup backup tool creates temporary
files in an insecure manner, which allows denial of service through a
symlink attack.
For the stable distribution (sarge) this problem has been fixed in
version 1.2.1-2sarge1.
For the upcoming stable distribution (etch) this problem has been
fixed in version 1.2.1-3.
For the unstable distribution (sid) this problem has been fixed in
version 1.2.1-3.
We recommend that you upgrade your flexbackup package.


Solution : http://www.debian.org/security/2006/dsa-1216
Risk factor : High';

if (description) {
 script_id(23702);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1216");
 script_cve_id("CVE-2005-4802");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1216] DSA-1216-1 flexbackup");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1216-1 flexbackup");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'flexbackup', release: '3.1', reference: '1.2.1-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package flexbackup is vulnerable in Debian 3.1.\nUpgrade to flexbackup_1.2.1-2sarge1\n');
}
if (deb_check(prefix: 'flexbackup', release: '4.0', reference: '1.2.1-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package flexbackup is vulnerable in Debian etch.\nUpgrade to flexbackup_1.2.1-3\n');
}
if (deb_check(prefix: 'flexbackup', release: '3.1', reference: '1.2.1-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package flexbackup is vulnerable in Debian sarge.\nUpgrade to flexbackup_1.2.1-2sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
