# This script was automatically generated from the dsa-1217
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Paul Szabo discovered that the netkit ftp server switches the user id too
late, which may lead to the bypass of access restrictions when running
on NFS. This update also adds return value checks to setuid() calls, which
may fail in some PAM configurations.
For the stable distribution (sarge) this problem has been fixed in
version 0.17-20sarge2.
For the upcoming stable distribution (etch) this problem has been
fixed in version 0.17-22.
For the unstable distribution (sid) this problem has been fixed in
version 0.17-22.
We recommend that you upgrade your ftpd package.


Solution : http://www.debian.org/security/2006/dsa-1217
Risk factor : High';

if (description) {
 script_id(23703);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1217");
 script_cve_id("CVE-2006-5778");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1217] DSA-1217-1 linux-ftpd");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1217-1 linux-ftpd");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'ftpd', release: '3.1', reference: '0.17-20sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ftpd is vulnerable in Debian 3.1.\nUpgrade to ftpd_0.17-20sarge2\n');
}
if (deb_check(prefix: 'linux-ftpd', release: '4.0', reference: '0.17-22')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-ftpd is vulnerable in Debian etch.\nUpgrade to linux-ftpd_0.17-22\n');
}
if (deb_check(prefix: 'linux-ftpd', release: '3.1', reference: '0.17-20sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-ftpd is vulnerable in Debian sarge.\nUpgrade to linux-ftpd_0.17-20sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
