# This script was automatically generated from the dsa-1219
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Multiple vulnerabilities have been found in the GNU texinfo package, a
documentation system for on-line information and printed output.
    Handling of temporary files is performed in an insecure manner, allowing
    an attacker to overwrite any file writable by the victim.
    A buffer overflow in util/texindex.c could allow an attacker to execute
    arbitrary code with the victim\'s access rights by inducing the victim to
    run texindex or tex2dvi on a specially crafted texinfo file.
For the stable distribution (sarge), these problems have been fixed in
version 4.7-2.2sarge2. Note that binary packages for the mipsel
architecture are not currently available due to technical problems with
the build host. These packages will be made available as soon as
possible.
For unstable (sid) and the upcoming stable release (etch), these
problems have been fixed in version 4.8.dfsg.1-4.
We recommend that you upgrade your texinfo package.


Solution : http://www.debian.org/security/2006/dsa-1219
Risk factor : High';

if (description) {
 script_id(23742);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1219");
 script_cve_id("CVE-2005-3011", "CVE-2006-4810");
 script_bugtraq_id(14854, 20959);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1219] DSA-1219-1 texinfo");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1219-1 texinfo");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'info', release: '3.1', reference: '4.7-2.2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package info is vulnerable in Debian 3.1.\nUpgrade to info_4.7-2.2sarge2\n');
}
if (deb_check(prefix: 'texinfo', release: '3.1', reference: '4.7-2.2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package texinfo is vulnerable in Debian 3.1.\nUpgrade to texinfo_4.7-2.2sarge2\n');
}
if (deb_check(prefix: 'texinfo', release: '3.1', reference: '4.7-2.2sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package texinfo is vulnerable in Debian sarge.\nUpgrade to texinfo_4.7-2.2sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
