# This script was automatically generated from the dsa-1225
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
This update covers packages for the little endian MIPS architecture
missing in the original advisory. For reference please find below the
original advisory text:
Several security related problems have been discovered in Mozilla and
derived products such as Mozilla Firefox.  The Common Vulnerabilities
and Exposures project identifies the following vulnerabilities:
    Tomas Kempinsky discovered that malformed FTP server responses
    could lead to denial of service.
    Ulrich Khn discovered that the correction for a cryptographic
    flaw in the handling of PKCS-1 certificates was incomplete, which
    allows the forgery of certificates.
    <q>shutdown</q> discovered that modification of JavaScript objects
    during execution could lead to the execution of arbitrary
    JavaScript bytecode.
    Jesse Ruderman and Martijn Wargers discovered several crashes in
    the layout engine, which might also allow execution of arbitrary
    code.
    Igor Bukanov and Jesse Ruderman discovered several crashes in the
    JavaScript engine, which might allow execution of arbitrary code.
This update also addresses several crashes, which could be triggered by
malicious websites and fixes a regression introduced in the previous
Mozilla update.
For the stable distribution (sarge) these problems have been fixed in
version 1.0.4-2sarge13.
For the unstable distribution (sid) these problems have been fixed in
the current iceweasel package 2.0+dfsg-1.
We recommend that you upgrade your mozilla-firefox package.


Solution : http://www.debian.org/security/2006/dsa-1225
Risk factor : High';

if (description) {
 script_id(23767);
 script_version("$Revision: 1.5 $");
 script_xref(name: "DSA", value: "1225");
 script_cve_id("CVE-2006-4310", "CVE-2006-5462", "CVE-2006-5463", "CVE-2006-5464", "CVE-2006-5748");
 script_bugtraq_id(19678, 20957);
 script_xref(name: "CERT", value: "335392");
 script_xref(name: "CERT", value: "390480");
 script_xref(name: "CERT", value: "495288");
 script_xref(name: "CERT", value: "714496");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1225] DSA-1225-2 mozilla-firefox");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1225-2 mozilla-firefox");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'mozilla-firefox', release: '3.1', reference: '1.0.4-2sarge13')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox_1.0.4-2sarge13\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '3.1', reference: '1.0.4-2sarge13')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox-dom-inspector_1.0.4-2sarge13\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '3.1', reference: '1.0.4-2sarge13')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox-gnome-support_1.0.4-2sarge13\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '3.1', reference: '1.0.4-2sarge13')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian sarge.\nUpgrade to mozilla-firefox_1.0.4-2sarge13\n');
}
if (w) { security_hole(port: 0, data: desc); }
