# This script was automatically generated from the dsa-1227
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several security related problems have been discovered in Mozilla and
derived products such as Mozilla Thunderbird.  The Common Vulnerabilities
and Exposures project identifies the following vulnerabilities:
    Tomas Kempinsky discovered that malformed FTP server responses
    could lead to denial of service.
    Ulrich Khn discovered that the correction for a cryptographic
    flaw in the handling of PKCS-1 certificates was incomplete, which
    allows the forgery of certificates.
    <q>shutdown</q> discovered that modification of JavaScript objects
    during execution could lead to the execution of arbitrary
    JavaScript bytecode.
    Jesse Ruderman and Martijn Wargers discovered several crashes in
    the layout engine, which might also allow execution of arbitrary
    code.
    Igor Bukanov and Jesse Ruderman discovered several crashes in the
    JavaScript engine, which might allow execution of arbitrary code.
This update also addresses several crashes, which could be triggered by
malicious websites and fixes a regression introduced in the previous
Mozilla update.
For the stable distribution (sarge) these problems have been fixed in
version 1.0.4-2sarge13.
For the unstable distribution (sid) these problems have been fixed in
the current icedove package 1.5.0.8.
We recommend that you upgrade your mozilla-thunderbird package.


Solution : http://www.debian.org/security/2006/dsa-1227
Risk factor : High';

if (description) {
 script_id(23768);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1227");
 script_cve_id("CVE-2006-4310", "CVE-2006-5462", "CVE-2006-5463", "CVE-2006-5464", "CVE-2006-5748");
 script_bugtraq_id(19678, 20957);
 script_xref(name: "CERT", value: "335392");
 script_xref(name: "CERT", value: "390480");
 script_xref(name: "CERT", value: "495288");
 script_xref(name: "CERT", value: "714496");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1227] DSA-1227-1 mozilla-thunderbird");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1227-1 mozilla-thunderbird");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'mozilla-thunderbird', release: '3.1', reference: '1.0.2-2.sarge1.0.8d.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird is vulnerable in Debian 3.1.\nUpgrade to mozilla-thunderbird_1.0.2-2.sarge1.0.8d.1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-dev', release: '3.1', reference: '1.0.2-2.sarge1.0.8d.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-dev is vulnerable in Debian 3.1.\nUpgrade to mozilla-thunderbird-dev_1.0.2-2.sarge1.0.8d.1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-inspector', release: '3.1', reference: '1.0.2-2.sarge1.0.8d.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-inspector is vulnerable in Debian 3.1.\nUpgrade to mozilla-thunderbird-inspector_1.0.2-2.sarge1.0.8d.1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-offline', release: '3.1', reference: '1.0.2-2.sarge1.0.8d.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-offline is vulnerable in Debian 3.1.\nUpgrade to mozilla-thunderbird-offline_1.0.2-2.sarge1.0.8d.1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-typeaheadfind', release: '3.1', reference: '1.0.2-2.sarge1.0.8d.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-typeaheadfind is vulnerable in Debian 3.1.\nUpgrade to mozilla-thunderbird-typeaheadfind_1.0.2-2.sarge1.0.8d.1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird', release: '3.1', reference: '1.0.4-2sarge13')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird is vulnerable in Debian sarge.\nUpgrade to mozilla-thunderbird_1.0.4-2sarge13\n');
}
if (w) { security_hole(port: 0, data: desc); }
