# This script was automatically generated from the dsa-1228
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Teemu Salmela discovered that the elinks character mode web browser
performs insufficient sanitising of smb:// URIs, which might lead to the
execution of arbitrary shell commands.
For the stable distribution (sarge) this problem has been fixed in
version 0.10.4-7.1.
For the upcoming stable distribution (etch) this problem has been
fixed in version 0.11.1-1.2.
For the unstable distribution (sid) this problem has been fixed in
version 0.11.1-1.2.
We recommend that you upgrade your elinks package.


Solution : http://www.debian.org/security/2006/dsa-1228
Risk factor : High';

if (description) {
 script_id(23770);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1228");
 script_cve_id("CVE-2006-5925");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1228] DSA-1228-1 elinks");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1228-1 elinks");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'elinks', release: '3.1', reference: '0.10.4-7.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package elinks is vulnerable in Debian 3.1.\nUpgrade to elinks_0.10.4-7.1\n');
}
if (deb_check(prefix: 'elinks-lite', release: '3.1', reference: '0.10.4-7.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package elinks-lite is vulnerable in Debian 3.1.\nUpgrade to elinks-lite_0.10.4-7.1\n');
}
if (deb_check(prefix: 'elinks', release: '4.0', reference: '0.11.1-1.2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package elinks is vulnerable in Debian etch.\nUpgrade to elinks_0.11.1-1.2\n');
}
if (deb_check(prefix: 'elinks', release: '3.1', reference: '0.10.4-7.1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package elinks is vulnerable in Debian sarge.\nUpgrade to elinks_0.10.4-7.1\n');
}
if (w) { security_hole(port: 0, data: desc); }
