# This script was automatically generated from the dsa-1247
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
An off-by-one error leading to a heap-based buffer overflow has been
identified in libapache-mod-auth-kerb, an Apache module for Kerberos
authentication.  The error could allow an attacker to trigger an
application crash or potentially execute arbitrary code by sending a
specially crafted kerberos message.
For the stable distribution (sarge), this problem has been fixed in
version 4.996-5.0-rc6-1sarge1.
For the unstable distribution (sid) and the forthcoming stable distribution
(etch), this problem has been fixed in version 5.3-1.
We recommend that you upgrade your libapache-mod-auth-kerb package.


Solution : http://www.debian.org/security/2007/dsa-1247
Risk factor : High';

if (description) {
 script_id(25225);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1247");
 script_cve_id("CVE-2006-5989");
 script_bugtraq_id(21214);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1247] DSA-1247-1 libapache-mod-auth-kerb");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1247-1 libapache-mod-auth-kerb");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libapache-mod-auth-kerb', release: '3.1', reference: '4.996-5.0-rc6-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-auth-kerb is vulnerable in Debian 3.1.\nUpgrade to libapache-mod-auth-kerb_4.996-5.0-rc6-1sarge1\n');
}
if (deb_check(prefix: 'libapache2-mod-auth-kerb', release: '3.1', reference: '4.996-5.0-rc6-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache2-mod-auth-kerb is vulnerable in Debian 3.1.\nUpgrade to libapache2-mod-auth-kerb_4.996-5.0-rc6-1sarge1\n');
}
if (deb_check(prefix: 'libapache-mod-auth-kerb', release: '3.1', reference: '4.996-5.0-rc6-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-auth-kerb is vulnerable in Debian sarge.\nUpgrade to libapache-mod-auth-kerb_4.996-5.0-rc6-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
