# This script was automatically generated from the dsa-1260
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Vladimir Nadvornik discovered that the fix for a vulnerability in the
PALM decoder of Imagemagick, a collection of image manipulation programs,
was ineffective. To avoid confusion a new CVE ID has been assigned;
the original issue was tracked as CVE-2006-5456.
For the stable distribution (sarge) this problem has been fixed in
version 6:6.0.6.2-2.9.
For the upcoming stable distribution (etch) this problem has been
fixed in version 7:6.2.4.5.dfsg1-0.14.
For the unstable distribution (sid) this problem has been fixed in
version 7:6.2.4.5.dfsg1-0.14.
We recommend that you upgrade your imagemagick packages.


Solution : http://www.debian.org/security/2007/dsa-1260
Risk factor : High';

if (description) {
 script_id(24347);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1260");
 script_cve_id("CVE-2007-0770");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1260] DSA-1260-1 imagemagick");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1260-1 imagemagick");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'imagemagick', release: '3.1', reference: '6.0.6.2-2.9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package imagemagick is vulnerable in Debian 3.1.\nUpgrade to imagemagick_6.0.6.2-2.9\n');
}
if (deb_check(prefix: 'libmagick6', release: '3.1', reference: '6.0.6.2-2.9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagick6 is vulnerable in Debian 3.1.\nUpgrade to libmagick6_6.0.6.2-2.9\n');
}
if (deb_check(prefix: 'libmagick6-dev', release: '3.1', reference: '6.0.6.2-2.9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagick6-dev is vulnerable in Debian 3.1.\nUpgrade to libmagick6-dev_6.0.6.2-2.9\n');
}
if (deb_check(prefix: 'perlmagick', release: '3.1', reference: '6.0.6.2-2.9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package perlmagick is vulnerable in Debian 3.1.\nUpgrade to perlmagick_6.0.6.2-2.9\n');
}
if (deb_check(prefix: 'imagemagick', release: '4.0', reference: '6.2.4.5.dfsg1-0.14')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package imagemagick is vulnerable in Debian etch.\nUpgrade to imagemagick_6.2.4.5.dfsg1-0.14\n');
}
if (deb_check(prefix: 'imagemagick', release: '3.1', reference: '6.0.6.2-2.9')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package imagemagick is vulnerable in Debian sarge.\nUpgrade to imagemagick_6.0.6.2-2.9\n');
}
if (w) { security_hole(port: 0, data: desc); }
