# This script was automatically generated from the dsa-1266
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Gerardo Richarte discovered that GnuPG, a free PGP replacement, provides
insufficient user feedback if an OpenPGP message contains both unsigned
and signed portions. Inserting text segments into an otherwise signed
message could be exploited to forge the content of signed messages.
This update prevents such attacks; the old behaviour can still be
activated by passing the --allow-multiple-messages option.
For the stable distribution (sarge) these problems have been fixed in
version 1.4.1-1.sarge7.
For the upcoming stable distribution (etch) these problems have been
fixed in version 1.4.6-2.
For the unstable distribution (sid) these problems have been fixed in
version 1.4.6-2.
We recommend that you upgrade your gnupg packages.


Solution : http://www.debian.org/security/2007/dsa-1266
Risk factor : High';

if (description) {
 script_id(24819);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1266");
 script_cve_id("CVE-2007-1263");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1266] DSA-1266-1 gnupg");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1266-1 gnupg");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gnupg', release: '3.1', reference: '1.4.1-1.sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gnupg is vulnerable in Debian 3.1.\nUpgrade to gnupg_1.4.1-1.sarge7\n');
}
if (deb_check(prefix: 'gnupg', release: '4.0', reference: '1.4.6-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gnupg is vulnerable in Debian etch.\nUpgrade to gnupg_1.4.6-2\n');
}
if (deb_check(prefix: 'gnupg', release: '3.1', reference: '1.4.1-1.sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gnupg is vulnerable in Debian sarge.\nUpgrade to gnupg_1.4.1-1.sarge7\n');
}
if (w) { security_hole(port: 0, data: desc); }
