# This script was automatically generated from the dsa-1268
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
iDefense reported several integer overflow bugs in libwpd, a library
for handling WordPerfect documents.  Attackers were able to exploit
these with carefully crafted Word Perfect files that could cause an
application linked with libwpd to crash or possibly execute arbitrary code.
For the stable distribution (sarge) these problems have been fixed in
version 0.8.1-1sarge1.
For the testing distribution (etch) these problems have been fixed in
version 0.8.7-6.
For the unstable distribution (sid) these problems have been fixed in
version 0.8.7-6.
We recommend that you upgrade your libwpd package.


Solution : http://www.debian.org/security/2007/dsa-1268
Risk factor : High';

if (description) {
 script_id(24835);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1268");
 script_cve_id("CVE-2007-0002");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1268] DSA-1268-1 libwpd");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1268-1 libwpd");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libwpd-stream8', release: '3.1', reference: '0.8.1-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd-stream8 is vulnerable in Debian 3.1.\nUpgrade to libwpd-stream8_0.8.1-1sarge1\n');
}
if (deb_check(prefix: 'libwpd-stream8c2a', release: '3.1', reference: '0.8.7-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd-stream8c2a is vulnerable in Debian 3.1.\nUpgrade to libwpd-stream8c2a_0.8.7-6\n');
}
if (deb_check(prefix: 'libwpd-tools', release: '3.1', reference: '0.8.7-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd-tools is vulnerable in Debian 3.1.\nUpgrade to libwpd-tools_0.8.7-6\n');
}
if (deb_check(prefix: 'libwpd8', release: '3.1', reference: '0.8.1-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd8 is vulnerable in Debian 3.1.\nUpgrade to libwpd8_0.8.1-1sarge1\n');
}
if (deb_check(prefix: 'libwpd8-dev', release: '3.1', reference: '0.8.7-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd8-dev is vulnerable in Debian 3.1.\nUpgrade to libwpd8-dev_0.8.7-6\n');
}
if (deb_check(prefix: 'libwpd8-doc', release: '3.1', reference: '0.8.7-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd8-doc is vulnerable in Debian 3.1.\nUpgrade to libwpd8-doc_0.8.7-6\n');
}
if (deb_check(prefix: 'libwpd8c2a', release: '3.1', reference: '0.8.7-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd8c2a is vulnerable in Debian 3.1.\nUpgrade to libwpd8c2a_0.8.7-6\n');
}
if (deb_check(prefix: 'libwpd', release: '3.1', reference: '0.8.1-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libwpd is vulnerable in Debian sarge.\nUpgrade to libwpd_0.8.1-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
