# This script was automatically generated from the dsa-1274
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
An integer underflow bug has been found in the file_printf function in
file, a tool to determine file types based analysis of file content.
The bug could allow an attacker to execute arbitrary code by inducing a
local user to examine a specially crafted file that triggers a buffer
overflow.
For the stable distribution (sarge), this problem has been fixed in
version 4.12-1sarge1.
For the upcoming stable distribution (etch), this problem has been fixed in
version 4.17-5etch1.
For the unstable distribution (sid), this problem has been fixed in
4.20-1.
We recommend that you upgrade your file package.


Solution : http://www.debian.org/security/2007/dsa-1274
Risk factor : High';

if (description) {
 script_id(25008);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1274");
 script_cve_id("CVE-2007-1536");
 script_bugtraq_id(23021);

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1274] DSA-1274-1 file");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1274-1 file");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'file', release: '', reference: '4.17-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian .\nUpgrade to file_4.17-5etch1\n');
}
if (deb_check(prefix: 'libmagic-dev', release: '', reference: '4.17-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic-dev is vulnerable in Debian .\nUpgrade to libmagic-dev_4.17-5etch1\n');
}
if (deb_check(prefix: 'libmagic1', release: '', reference: '4.17-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic1 is vulnerable in Debian .\nUpgrade to libmagic1_4.17-5etch1\n');
}
if (deb_check(prefix: 'python-magic', release: '', reference: '4.17-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package python-magic is vulnerable in Debian .\nUpgrade to python-magic_4.17-5etch1\n');
}
if (deb_check(prefix: 'file', release: '3.1', reference: '4.12-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian 3.1.\nUpgrade to file_4.12-1sarge1\n');
}
if (deb_check(prefix: 'libmagic-dev', release: '3.1', reference: '4.12-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic-dev is vulnerable in Debian 3.1.\nUpgrade to libmagic-dev_4.12-1sarge1\n');
}
if (deb_check(prefix: 'libmagic1', release: '3.1', reference: '4.12-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic1 is vulnerable in Debian 3.1.\nUpgrade to libmagic1_4.12-1sarge1\n');
}
if (deb_check(prefix: 'file', release: '4.0', reference: '4.17-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian etch.\nUpgrade to file_4.17-5etch1\n');
}
if (deb_check(prefix: 'file', release: '3.1', reference: '4.12-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian sarge.\nUpgrade to file_4.12-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
