# This script was automatically generated from the dsa-1276
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the MIT reference
implementation of the Kerberos network authentication protocol suite,
which may lead to the execution of arbitrary code. The Common 
Vulnerabilities and Exposures project identifies the following problems:
    It was discovered that the krb5 telnet daemon performs insufficient
    validation of usernames, which might allow unauthorized logins or
    privilege escalation.
    iDefense discovered that a buffer overflow in the logging code of the
    KDC and the administration daemon might lead to arbitrary code
    execution.
    It was discovered that a double free in the RPCSEC_GSS part of the 
    GSS library code might lead to arbitrary code execution.
For the stable distribution (sarge) these problems have been fixed in
version 1.3.6-2sarge4.
For the upcoming stable distribution (etch) these problems have been fixed
in version 1.4.4-7etch1.
For the unstable distribution (sid) these problems will be fixed soon.
We recommend that you upgrade your Kerberos packages.


Solution : http://www.debian.org/security/2007/dsa-1276
Risk factor : High';

if (description) {
 script_id(25010);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1276");
 script_cve_id("CVE-2007-0956", "CVE-2007-0957", "CVE-2007-1216");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1276] DSA-1276-1 krb5");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1276-1 krb5");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'krb5-admin-server', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-admin-server is vulnerable in Debian 3.1.\nUpgrade to krb5-admin-server_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-clients', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-clients is vulnerable in Debian 3.1.\nUpgrade to krb5-clients_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-doc', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-doc is vulnerable in Debian 3.1.\nUpgrade to krb5-doc_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-ftpd', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-ftpd is vulnerable in Debian 3.1.\nUpgrade to krb5-ftpd_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-kdc', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-kdc is vulnerable in Debian 3.1.\nUpgrade to krb5-kdc_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-rsh-server', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-rsh-server is vulnerable in Debian 3.1.\nUpgrade to krb5-rsh-server_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-telnetd', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-telnetd is vulnerable in Debian 3.1.\nUpgrade to krb5-telnetd_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-user', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-user is vulnerable in Debian 3.1.\nUpgrade to krb5-user_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'libkadm55', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkadm55 is vulnerable in Debian 3.1.\nUpgrade to libkadm55_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'libkrb5-dev', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb5-dev is vulnerable in Debian 3.1.\nUpgrade to libkrb5-dev_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'libkrb53', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb53 is vulnerable in Debian 3.1.\nUpgrade to libkrb53_1.3.6-2sarge4\n');
}
if (deb_check(prefix: 'krb5-admin-server', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-admin-server is vulnerable in Debian 4.0.\nUpgrade to krb5-admin-server_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5-clients', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-clients is vulnerable in Debian 4.0.\nUpgrade to krb5-clients_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5-doc', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-doc is vulnerable in Debian 4.0.\nUpgrade to krb5-doc_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5-ftpd', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-ftpd is vulnerable in Debian 4.0.\nUpgrade to krb5-ftpd_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5-kdc', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-kdc is vulnerable in Debian 4.0.\nUpgrade to krb5-kdc_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5-rsh-server', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-rsh-server is vulnerable in Debian 4.0.\nUpgrade to krb5-rsh-server_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5-telnetd', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-telnetd is vulnerable in Debian 4.0.\nUpgrade to krb5-telnetd_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5-user', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5-user is vulnerable in Debian 4.0.\nUpgrade to krb5-user_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'libkadm55', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkadm55 is vulnerable in Debian 4.0.\nUpgrade to libkadm55_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'libkrb5-dbg', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb5-dbg is vulnerable in Debian 4.0.\nUpgrade to libkrb5-dbg_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'libkrb5-dev', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb5-dev is vulnerable in Debian 4.0.\nUpgrade to libkrb5-dev_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'libkrb53', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libkrb53 is vulnerable in Debian 4.0.\nUpgrade to libkrb53_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5', release: '4.0', reference: '1.4.4-7etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5 is vulnerable in Debian etch.\nUpgrade to krb5_1.4.4-7etch1\n');
}
if (deb_check(prefix: 'krb5', release: '3.1', reference: '1.3.6-2sarge4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package krb5 is vulnerable in Debian sarge.\nUpgrade to krb5_1.3.6-2sarge4\n');
}
if (w) { security_hole(port: 0, data: desc); }
