# This script was automatically generated from the dsa-1278
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A buffer overflow has been dicovered in the man command that could
allow an attacker to execute code as the man user by providing
specially crafted arguments to the -H flag.  This is likely to be an
issue only on machines with the man and mandb programs installed
setuid.
For the stable distribution (sarge), this problem has been fixed in
version 2.4.2-21sarge1.
For the upcoming stable distribution (etch) and the unstable
distribution (sid), this problem has been fixed in version 2.4.3-5.
We recommend that you upgrade your man-db package.


Solution : http://www.debian.org/security/2007/dsa-1278
Risk factor : High';

if (description) {
 script_id(25012);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1278");
 script_cve_id("CVE-2006-4250");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1278] DSA-1278-1 man-db");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1278-1 man-db");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'man-db', release: '3.1', reference: '2.4.2-21sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package man-db is vulnerable in Debian 3.1.\nUpgrade to man-db_2.4.2-21sarge1\n');
}
if (deb_check(prefix: 'man-db', release: '3.1', reference: '2.4.2-21sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package man-db is vulnerable in Debian sarge.\nUpgrade to man-db_2.4.2-21sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
