# This script was automatically generated from the dsa-1279
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that WebCalendar, a PHP-based calendar application,
performs insufficient sanitising in the exports handler, which allows
injection of web script.
For the old stable distribution (sarge) this problem has been fixed in
version 0.9.45-4sarge7.
The stable distribution (etch) no longer contains WebCalendar packages.
For the unstable distribution (sid) this problem has been fixed in
version 1.0.5-2.
We recommend that you upgrade your webcalendar package.


Solution : http://www.debian.org/security/2007/dsa-1279
Risk factor : High';

if (description) {
 script_id(25096);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1279");
 script_cve_id("CVE-2006-6669");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1279] DSA-1279-1 webcalendar");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1279-1 webcalendar");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'webcalendar', release: '3.1', reference: '0.9.45-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package webcalendar is vulnerable in Debian 3.1.\nUpgrade to webcalendar_0.9.45-4sarge7\n');
}
if (deb_check(prefix: 'webcalendar', release: '3.1', reference: '0.9.45-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package webcalendar is vulnerable in Debian sarge.\nUpgrade to webcalendar_0.9.45-4sarge7\n');
}
if (w) { security_hole(port: 0, data: desc); }
