# This script was automatically generated from the dsa-1289
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several local and remote vulnerabilities have been discovered in the Linux
kernel that may lead to a denial of service or the execution of arbitrary
code. The Common Vulnerabilities and Exposures project identifies the
following problems:
    Michal Miroslaw reported a DoS vulnerability (crash) in netfilter.
    A remote attacker can cause a NULL pointer dereference in the
    nfnetlink_log function.
    Patrick McHardy reported an vulnerability in netfilter that may
    allow attackers to bypass certain firewall rules. The nfctinfo
    value of reassembled IPv6 packet fragments were incorrectly initialized
    to 0 which allowed these packets to become tracked as ESTABLISHED.
    Jaco Kroon reported a bug in which NETLINK_FIB_LOOKUP packages were
    incorrectly routed back to the kernel resulting in an infinite
    recursion condition. Local users can exploit this behavior
    to cause a DoS (crash).
For the stable distribution (etch) these problems have been fixed in version 
2.6.18.dfsg.1-12etch2.
The following matrix lists additional packages that were rebuilt for
compatibility with or to take advantage of this update:
We recommend that you upgrade your kernel package immediately and reboot
the machine. If you have built a custom kernel from the kernel source
package, you will need to rebuild to take advantage of these fixes.


Solution : http://www.debian.org/security/2007/dsa-1289
Risk factor : High';

if (description) {
 script_id(25226);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1289");
 script_cve_id("CVE-2007-1496", "CVE-2007-1497", "CVE-2007-1861");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1289] DSA-1289-1 linux-2.6");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1289-1 linux-2.6");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'fai-kernels', release: '4.0', reference: '1.17+etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fai-kernels is vulnerable in Debian 4.0.\nUpgrade to fai-kernels_1.17+etch2\n');
}
if (deb_check(prefix: 'kernel-patch-openvz', release: '4.0', reference: '028.18.1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-openvz is vulnerable in Debian 4.0.\nUpgrade to kernel-patch-openvz_028.18.1etch1\n');
}
if (deb_check(prefix: 'linux-doc-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-doc-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-doc-2.6.18_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-486', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-486 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-486_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-686-bigmem', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-686-bigmem_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-alpha', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-alpha_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-arm', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-arm is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-arm_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-hppa', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-hppa is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-hppa_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-i386', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-i386 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-i386_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-ia64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-ia64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-ia64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-mips', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-mips is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-mips_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-mipsel', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-mipsel is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-mipsel_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-powerpc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-s390', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-s390_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-all-sparc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-all-sparc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-all-sparc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-alpha-generic', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-alpha-generic_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-alpha-legacy', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-alpha-legacy_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-alpha-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-alpha-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-footbridge', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-footbridge_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-iop32x', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-iop32x_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-itanium', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-itanium_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-ixp4xx', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-ixp4xx_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-k7', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-k7_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-mckinley', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-mckinley_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-parisc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-parisc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-parisc-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-parisc-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-parisc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-parisc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-parisc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-parisc64-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-powerpc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-powerpc-miboot', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-powerpc-miboot_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-powerpc-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-powerpc-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-powerpc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-prep', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-prep is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-prep_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-qemu', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-qemu_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-r3k-kn02', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-r3k-kn02_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-r4k-ip22', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-r4k-ip22_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-r4k-kn04', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-r4k-kn04_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-r5k-cobalt', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-r5k-cobalt_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-r5k-ip32', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-r5k-ip32_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-rpc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-rpc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-s390', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-s390_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-s390x', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-s390x_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-s3c2410', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-s3c2410_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-sb1-bcm91250a', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-sb1-bcm91250a_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-sb1a-bcm91480b', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-sb1a-bcm91480b_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-sparc32', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-sparc32_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-sparc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-sparc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-sparc64-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-alpha', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-alpha_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-k7', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-k7_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-powerpc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-powerpc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-s390x', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-s390x_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-vserver-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-vserver-sparc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-xen', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-xen is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-xen_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-xen-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-xen-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-xen-vserver', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-xen-vserver is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-xen-vserver_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-xen-vserver-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-headers-2.6.18-4-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-headers-2.6.18-4-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-headers-2.6.18-4-xen-vserver-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-486', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-486 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-486_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-686-bigmem', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-686-bigmem is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-686-bigmem_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-alpha-generic', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-alpha-generic is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-alpha-generic_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-alpha-legacy', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-alpha-legacy is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-alpha-legacy_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-alpha-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-alpha-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-alpha-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-footbridge', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-footbridge is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-footbridge_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-iop32x', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-iop32x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-iop32x_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-itanium', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-itanium is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-itanium_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-ixp4xx', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-ixp4xx is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-ixp4xx_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-k7', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-k7_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-mckinley', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-mckinley is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-mckinley_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-parisc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-parisc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-parisc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-parisc-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-parisc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-parisc-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-parisc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-parisc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-parisc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-parisc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-parisc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-parisc64-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-powerpc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-powerpc-miboot', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-powerpc-miboot is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-powerpc-miboot_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-powerpc-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-powerpc-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-powerpc-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-powerpc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-prep', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-prep is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-prep_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-qemu', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-qemu is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-qemu_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-r3k-kn02', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-r3k-kn02 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-r3k-kn02_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-r4k-ip22', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-r4k-ip22 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-r4k-ip22_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-r4k-kn04', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-r4k-kn04 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-r4k-kn04_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-r5k-cobalt', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-r5k-cobalt is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-r5k-cobalt_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-r5k-ip32', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-r5k-ip32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-r5k-ip32_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-rpc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-rpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-rpc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-s390', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-s390 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-s390_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-s390-tape', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-s390-tape is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-s390-tape_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-s390x', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-s390x_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-s3c2410', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-s3c2410 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-s3c2410_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-sb1-bcm91250a', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-sb1-bcm91250a is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-sb1-bcm91250a_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-sb1a-bcm91480b', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-sb1a-bcm91480b is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-sb1a-bcm91480b_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-sparc32', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-sparc32 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-sparc32_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-sparc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-sparc64-smp', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-sparc64-smp is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-sparc64-smp_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-alpha', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-alpha is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-alpha_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-k7', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-k7 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-k7_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-powerpc', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-powerpc is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-powerpc_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-powerpc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-powerpc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-powerpc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-s390x', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-s390x is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-s390x_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-vserver-sparc64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-vserver-sparc64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-vserver-sparc64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-xen-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-xen-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-xen-vserver-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-image-2.6.18-4-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-image-2.6.18-4-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-image-2.6.18-4-xen-vserver-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-manual-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-manual-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-manual-2.6.18_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-4-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-4-xen-686 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-4-xen-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-4-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-4-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-4-xen-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-4-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-4-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-4-xen-vserver-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-modules-2.6.18-4-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-modules-2.6.18-4-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to linux-modules-2.6.18-4-xen-vserver-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-patch-debian-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-patch-debian-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-patch-debian-2.6.18_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-source-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-source-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-source-2.6.18_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-support-2.6.18-4', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-support-2.6.18-4 is vulnerable in Debian 4.0.\nUpgrade to linux-support-2.6.18-4_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-tree-2.6.18', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-tree-2.6.18 is vulnerable in Debian 4.0.\nUpgrade to linux-tree-2.6.18_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'user-mode-linux', release: '4.0', reference: '2.6.18-1um-2etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package user-mode-linux is vulnerable in Debian 4.0.\nUpgrade to user-mode-linux_2.6.18-1um-2etch2\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-4-xen-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-4-xen-686 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-4-xen-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-4-xen-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-4-xen-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-4-xen-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-4-xen-vserver-686', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-4-xen-vserver-686 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-4-xen-vserver-686_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'xen-linux-system-2.6.18-4-xen-vserver-amd64', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-linux-system-2.6.18-4-xen-vserver-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-linux-system-2.6.18-4-xen-vserver-amd64_2.6.18.dfsg.1-12etch2\n');
}
if (deb_check(prefix: 'linux-2.6', release: '4.0', reference: '2.6.18.dfsg.1-12etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package linux-2.6 is vulnerable in Debian etch.\nUpgrade to linux-2.6_2.6.18.dfsg.1-12etch2\n');
}
if (w) { security_hole(port: 0, data: desc); }
