# This script was automatically generated from the dsa-1290
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the webmail package Squirrelmail performs
insufficient sanitising inside the HTML filter, which allows the
injection of arbitrary web script code during the display of HTML
email messages.
For the oldstable distribution (sarge) this problem has been fixed in
version 2:1.4.4-11.
For the stable distribution (etch) this problem has been fixed in
version 2:1.4.9a-2.
For the unstable distribution (sid) this problem has been fixed in
version 2:1.4.10a-1.
We recommend that you upgrade your squirrelmail package.


Solution : http://www.debian.org/security/2007/dsa-1290
Risk factor : High';

if (description) {
 script_id(25227);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1290");
 script_cve_id("CVE-2007-1262");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1290] DSA-1290-1 squirrelmail");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1290-1 squirrelmail");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'squirrelmail', release: '3.1', reference: '1.4.4-11')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squirrelmail is vulnerable in Debian 3.1.\nUpgrade to squirrelmail_1.4.4-11\n');
}
if (deb_check(prefix: 'squirrelmail', release: '4.0', reference: '1.4.9a-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squirrelmail is vulnerable in Debian 4.0.\nUpgrade to squirrelmail_1.4.9a-2\n');
}
if (deb_check(prefix: 'squirrelmail', release: '4.0', reference: '1.4.9a-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squirrelmail is vulnerable in Debian etch.\nUpgrade to squirrelmail_1.4.9a-2\n');
}
if (deb_check(prefix: 'squirrelmail', release: '3.1', reference: '1.4.4-11')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package squirrelmail is vulnerable in Debian sarge.\nUpgrade to squirrelmail_1.4.4-11\n');
}
if (w) { security_hole(port: 0, data: desc); }
