# This script was automatically generated from the dsa-1291
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several issues have been identified in Samba, the SMB/CIFS
file- and print-server implementation for GNU/Linux.
    When translating SIDs to/from names using Samba local list of user and
    group accounts, a logic error in the smbd daemon\'s internal security
    stack may result in a transition to the root user id rather than the
    non-root user.  The user is then able to temporarily issue SMB/CIFS
    protocol operations as the root user.  This window of opportunity may
    allow the attacker to establish addition means of gaining root access to
    the server.
    Various bugs in Samba\'s NDR parsing can allow a user to send specially
    crafted MS-RPC requests that will overwrite the heap space with user
    defined data.
    Unescaped user input parameters are passed as arguments to /bin/sh
    allowing for remote command execution.
For the stable distribution (etch), these problems have been fixed in
version 3.0.24-6etch1.
For the testing and unstable distributions (lenny and sid,
respectively), these problems have been fixed in version 3.0.25-1.
We recommend that you upgrade your samba package.


Solution : http://www.debian.org/security/2007/dsa-1291
Risk factor : High';

if (description) {
 script_id(25228);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1291");
 script_cve_id("CVE-2007-2444", "CVE-2007-2446", "CVE-2007-2447");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1291] DSA-1291-1 samba");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1291-1 samba");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libpam-smbpass', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpam-smbpass is vulnerable in Debian 4.0.\nUpgrade to libpam-smbpass_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'libsmbclient', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsmbclient is vulnerable in Debian 4.0.\nUpgrade to libsmbclient_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'libsmbclient-dev', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libsmbclient-dev is vulnerable in Debian 4.0.\nUpgrade to libsmbclient-dev_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'python-samba', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package python-samba is vulnerable in Debian 4.0.\nUpgrade to python-samba_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'samba', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package samba is vulnerable in Debian 4.0.\nUpgrade to samba_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'samba-common', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package samba-common is vulnerable in Debian 4.0.\nUpgrade to samba-common_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'samba-dbg', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package samba-dbg is vulnerable in Debian 4.0.\nUpgrade to samba-dbg_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'samba-doc', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package samba-doc is vulnerable in Debian 4.0.\nUpgrade to samba-doc_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'samba-doc-pdf', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package samba-doc-pdf is vulnerable in Debian 4.0.\nUpgrade to samba-doc-pdf_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'smbclient', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package smbclient is vulnerable in Debian 4.0.\nUpgrade to smbclient_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'smbfs', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package smbfs is vulnerable in Debian 4.0.\nUpgrade to smbfs_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'swat', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package swat is vulnerable in Debian 4.0.\nUpgrade to swat_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'winbind', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package winbind is vulnerable in Debian 4.0.\nUpgrade to winbind_3.0.24-6etch1\n');
}
if (deb_check(prefix: 'samba', release: '4.0', reference: '3.0.24-6etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package samba is vulnerable in Debian etch.\nUpgrade to samba_3.0.24-6etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
