# This script was automatically generated from the dsa-1304
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
                 CVE-2006-6060 CVE-2006-6106 CVE-2006-6535 CVE-2007-0958
                 CVE-2007-1357 CVE-2007-1592
Several local and remote vulnerabilities have been discovered in the Linux
kernel that may lead to a denial of service or the execution of arbitrary
code. 
This update also fixes a regression in the smbfs subsystem which was introduced
in DSA-1233 which caused symlinks to be interpreted as regular files.
The Common Vulnerabilities and Exposures project identifies the
following problems:
    David Gibson reported an issue in the hugepage code which could permit
    a local DoS (system crash) on appropriately configured systems.
    Doug Chapman discovered a potential local DoS (deadlock) in the mincore
    function caused by improper lock handling.
    Ang Way Chuang reported a remote DoS (crash) in the dvb driver which
    can be triggered by a ULE package with an SNDU length of 0.
    Eric Sandeen provided a fix for a local memory corruption vulnerability
    resulting from a misinterpretation of return values when operating on
    inodes which have been marked bad.
    Darrick Wong discovered a local DoS (crash) vulnerability resulting from
    the incorrect initialization of <q>nr_pages</q> in aio_setup_ring().
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted iso9660 filesystem.
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted ext3 filesystem.
    LMH reported a potential local DoS which could be exploited by a malicious
    user with the privileges to mount and read a corrupted hfs filesystem on
    systems with SELinux hooks enabled (Debian does not enable SELinux by
    default).
    LMH reported a potential local DoS (infinie loop) which could be exploited
    by a malicious user with the privileges to mount and read a corrupted NTFS
    filesystem.
    Marcel Holtman discovered multiple buffer overflows in the Bluetooth
    subsystem which can be used to trigger a remote DoS (crash) and potentially
    execute arbitray code.
    Kostantin Khorenko discovered an invalid error path in dev_queue_xmit()
    which could be exploited by a local user to cause data corruption.
    Santosh Eraniose reported a vulnerability that allows local users to read
    otherwise unreadable files by triggering a core dump while using PT_INTERP.
    This is related to CVE-2004-1073.
    Jean Delvare reported a vulnerability in the appletalk subsystem.
    Systems with the appletalk module loaded can be triggered to crash
    by other systems on the local network via a malformed frame.
    Masayuki Nakagawa discovered that flow labels were inadvertently
    being shared between listening sockets and child sockets. This defect
    can be exploited by local users to cause a DoS (Oops).
The following matrix explains which kernel version for which architecture
fix the problems mentioned above:
We recommend that you upgrade your kernel package immediately and reboot
the ma
[...]

Solution : http://www.debian.org/security/2007/dsa-1304
Risk factor : High';

if (description) {
 script_id(25529);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1304");
 script_cve_id("CVE-2005-4811", "CVE-2006-4623", "CVE-2006-4814", "CVE-2006-5753");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1304] DSA-1304-1 kernel-source-2.6.8");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1304-1 kernel-source-2.6.8");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'fai-kernels', release: '3.1', reference: '1.9.1sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fai-kernels is vulnerable in Debian 3.1.\nUpgrade to fai-kernels_1.9.1sarge6\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-3-386', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-3-386 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-3-386_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-3-586tsc', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-3-586tsc is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-3-586tsc_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-3-686', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-3-686 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-3-686_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-3-686-smp', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-3-686-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-3-686-smp_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-3-k6', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-3-k6 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-3-k6_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-3-k7', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-3-k7 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-3-k7_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.4.27-3-k7-smp', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.4.27-3-k7-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.4.27-3-k7-smp_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-386', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-386 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-386_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-686', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-686 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-686_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-686-smp', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-686-smp_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-k7', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-k7 is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-k7_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'hostap-modules-2.6.8-4-k7-smp', release: '3.1', reference: '0.3.7-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hostap-modules-2.6.8-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to hostap-modules-2.6.8-4-k7-smp_0.3.7-1sarge2\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power3', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power3 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power3_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power3-smp', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power3-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power3-smp_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power4', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power4 is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power4_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-power4-smp', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-power4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-power4-smp_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-powerpc', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-powerpc_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-build-2.6.8-4-powerpc-smp', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-build-2.6.8-4-powerpc-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-build-2.6.8-4-powerpc-smp_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-doc-2.6.8', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-doc-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-doc-2.6.8_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-itanium', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-itanium_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-itanium-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-itanium-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-mckinley', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-mckinley_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6-mckinley-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6-mckinley-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-amd64-generic', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-amd64-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-amd64-generic_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-amd64-k8', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-amd64-k8 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-amd64-k8_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-amd64-k8-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-amd64-k8-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-amd64-k8-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-em64t-p4', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-em64t-p4 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-em64t-p4_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-13-em64t-p4-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-13-em64t-p4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-13-em64t-p4-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-32', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-32 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-32_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-32-smp', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-32-smp_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-386', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-386_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-64', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-64 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-64_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-64-smp', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-64-smp_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-686', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-686_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-686-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-686-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-generic', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-generic_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-itanium', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-itanium_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-itanium-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-itanium-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-k7', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-k7_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-k7-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-k7-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-mckinley', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-mckinley_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-mckinley-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-mckinley-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-sparc32', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-sparc32_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-sparc64', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-sparc64_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-headers-2.6.8-4-sparc64-smp', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-headers-2.6.8-4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-headers-2.6.8-4-sparc64-smp_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6-itanium', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-itanium_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6-itanium-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-itanium-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6-mckinley', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-mckinley_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6-mckinley-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6-mckinley-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-amd64-generic', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-amd64-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-amd64-generic_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-amd64-k8', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-amd64-k8 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-amd64-k8_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-amd64-k8-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-amd64-k8-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-amd64-k8-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-em64t-p4', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-em64t-p4 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-em64t-p4_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-13-em64t-p4-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-13-em64t-p4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-13-em64t-p4-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-32', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-32 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-32_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-32-smp', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-32-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-32-smp_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-386', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-386 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-386_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-64', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-64 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-64_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-64-smp', release: '3.1', reference: '2.6.8-6sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-64-smp_2.6.8-6sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-686', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-686 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-686_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-686-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-686-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-686-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-generic', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-generic is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-generic_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-itanium', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-itanium is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-itanium_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-itanium-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-itanium-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-itanium-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-k7', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-k7 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-k7_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-k7-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-k7-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-k7-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-mckinley', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-mckinley is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-mckinley_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-mckinley-smp', release: '3.1', reference: '2.6.8-14sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-mckinley-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-mckinley-smp_2.6.8-14sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power3', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power3 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power3_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power3-smp', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power3-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power3-smp_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power4', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power4 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power4_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-power4-smp', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-power4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-power4-smp_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-powerpc', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-powerpc is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-powerpc_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-powerpc-smp', release: '3.1', reference: '2.6.8-12sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-powerpc-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-powerpc-smp_2.6.8-12sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-s390', release: '3.1', reference: '2.6.8-5sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-s390 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-s390_2.6.8-5sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-s390-tape', release: '3.1', reference: '2.6.8-5sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-s390-tape is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-s390-tape_2.6.8-5sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-s390x', release: '3.1', reference: '2.6.8-5sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-s390x is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-s390x_2.6.8-5sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-smp', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-smp_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-sparc32', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-sparc32 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-sparc32_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-sparc64', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-sparc64 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-sparc64_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-4-sparc64-smp', release: '3.1', reference: '2.6.8-15sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-4-sparc64-smp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-4-sparc64-smp_2.6.8-15sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-amiga', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-amiga is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-amiga_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-atari', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-atari is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-atari_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-bvme6000', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-bvme6000 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-bvme6000_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-hp', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-hp is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-hp_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-mac', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-mac is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-mac_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-mvme147', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-mvme147 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-mvme147_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-mvme16x', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-mvme16x is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-mvme16x_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-q40', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-q40 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-q40_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-image-2.6.8-sun3', release: '3.1', reference: '2.6.8-4sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-image-2.6.8-sun3 is vulnerable in Debian 3.1.\nUpgrade to kernel-image-2.6.8-sun3_2.6.8-4sarge7\n');
}
if (deb_check(prefix: 'kernel-patch-2.6.8-s390', release: '3.1', reference: '2.6.8-5sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-2.6.8-s390 is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-2.6.8-s390_2.6.8-5sarge7\n');
}
if (deb_check(prefix: 'kernel-patch-debian-2.6.8', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-patch-debian-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-patch-debian-2.6.8_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-source-2.6.8', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-source-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-source-2.6.8_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'kernel-tree-2.6.8', release: '3.1', reference: '2.6.8-16sarge7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package kernel-tree-2.6.8 is vulnerable in Debian 3.1.\nUpgrade to kernel-tree-2.6.8_2.6.8-16sarge7\n');
}
if (deb_check(prefix: 'mol-modules-2.6.8-4-powerpc', release: '3.1', reference: '0.9.70+2.6.8+12sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mol-modules-2.6.8-4-powerpc is vulnerable in Debian 3.1.\nUpgrade to mol-modules-2.6.8-4-powerpc_0.9.70+2.6.8+12sarge2\n');
}
if (deb_check(prefix: 'mol-modules-2.6.8-4-powerpc-smp', release: '3.1', reference: '0.9.70+2.6.8+12sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mol-modules-2.6.8-4-powerpc-smp is vulnerable in Debian 3.1.\nUpgrade to mol-modules-2.6.8-4-powerpc-smp_0.9.70+2.6.8+12sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
