# This script was automatically generated from the dsa-1305
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Icedove mail client,
an unbranded version of the Thunderbird client. The Common Vulnerabilities and
Exposures project identifies the following problems:
    Gatan Leurent discovered a cryptographical weakness in APOP
    authentication, which reduces the required efforts for an MITM attack
    to intercept a password. The update enforces stricter validation, which
    prevents this attack.
    Boris Zbarsky, Eli Friedman, Georgi Guninski, Jesse Ruderman, Martijn
    Wargers and Olli Pettay discovered crashes in the layout engine, which
    might allow the execution of arbitrary code.
    Brendan Eich, Igor Bukanov, Jesse Ruderman, <q>moz_bug_r_a4</q> and Wladimir Palant
    discovered crashes in the Javascript engine, which might allow the execution of
    arbitrary code. Generally, enabling Javascript in Icedove is not recommended.
Fixes for the oldstable distribution (sarge) are not available. While there
will be another round of security updates for Mozilla products, Debian doesn\'t
have the resources to backport further security fixes to the old Mozilla
products. You\'re strongly encouraged to upgrade to stable as soon as possible.
For the stable distribution (etch) these problems have been fixed in version
1.5.0.12.dfsg1-0etch1.
The unstable distribution (sid) will be fixed soon.
We recommend that you upgrade your icedove packages.


Solution : http://www.debian.org/security/2007/dsa-1305
Risk factor : High';

if (description) {
 script_id(25504);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1305");
 script_cve_id("CVE-2007-1558", "CVE-2007-2867", "CVE-2007-2868");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1305] DSA-1305-1 icedove");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1305-1 icedove");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'icedove', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove is vulnerable in Debian 4.0.\nUpgrade to icedove_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-dbg', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-dbg is vulnerable in Debian 4.0.\nUpgrade to icedove-dbg_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-dev', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-dev is vulnerable in Debian 4.0.\nUpgrade to icedove-dev_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-gnome-support', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-gnome-support is vulnerable in Debian 4.0.\nUpgrade to icedove-gnome-support_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-inspector', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-inspector is vulnerable in Debian 4.0.\nUpgrade to icedove-inspector_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove-typeaheadfind', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove-typeaheadfind is vulnerable in Debian 4.0.\nUpgrade to icedove-typeaheadfind_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-dev', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-dev is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird-dev_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-inspector', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird-inspector_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'mozilla-thunderbird-typeaheadfind', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-thunderbird-typeaheadfind is vulnerable in Debian 4.0.\nUpgrade to mozilla-thunderbird-typeaheadfind_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird is vulnerable in Debian 4.0.\nUpgrade to thunderbird_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-dbg', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-dbg is vulnerable in Debian 4.0.\nUpgrade to thunderbird-dbg_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-dev', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-dev is vulnerable in Debian 4.0.\nUpgrade to thunderbird-dev_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-gnome-support', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-gnome-support is vulnerable in Debian 4.0.\nUpgrade to thunderbird-gnome-support_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-inspector', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-inspector is vulnerable in Debian 4.0.\nUpgrade to thunderbird-inspector_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'thunderbird-typeaheadfind', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thunderbird-typeaheadfind is vulnerable in Debian 4.0.\nUpgrade to thunderbird-typeaheadfind_1.5.0.12.dfsg1-0etch1\n');
}
if (deb_check(prefix: 'icedove', release: '4.0', reference: '1.5.0.12.dfsg1-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package icedove is vulnerable in Debian etch.\nUpgrade to icedove_1.5.0.12.dfsg1-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
