# This script was automatically generated from the dsa-1308
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common 
Vulnerabilities and Exposures project identifies the following problems:
    Nicolas Derouet discovered that Iceweasel performs insufficient 
    validation of cookies, which could lead to denial of service.
    Boris Zbarsky, Eli Friedman, Georgi Guninski, Jesse Ruderman, Martijn
    Wargers and Olli Pettay discovered crashes in the layout engine, which
    might allow the execution of arbitrary code.
    Brendan Eich, Igor Bukanov, Jesse Ruderman, <q>moz_bug_r_a4</q> and Wladimir Palant
    discovered crashes in the javascript engine, which might allow the execution of
    arbitrary code.
    <q>Marcel</q> discovered that malicous web sites can cause massive
    resource consumption through the auto completion feature, resulting
    in denial of service.
    <q>moz_bug_r_a4</q> discovered that adding an event listener through the
     addEventListener() function allows cross-site scripting.
    Chris Thomas discovered that XUL popups can be abused for spoofing or
    phishing attacks.
Fixes for the oldstable distribution (sarge) are not available. While there
will be another round of security updates for Mozilla products, Debian doesn\'t
have the resources to backport further security fixes to the old Mozilla
products. You\'re strongly encouraged to upgrade to stable as soon as possible.
For the stable distribution (etch) these problems have been fixed in version
2.0.0.4-0etch1. A build for the Alpha architecture is not yet available, it will
be provided later.
For the unstable distribution (sid) these problems have been fixed in version
2.0.0.4-1.
We recommend that you upgrade your iceweasel packages.


Solution : http://www.debian.org/security/2007/dsa-1308
Risk factor : High';

if (description) {
 script_id(25530);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1308");
 script_cve_id("CVE-2007-1362", "CVE-2007-2867", "CVE-2007-2868", "CVE-2007-2869", "CVE-2007-2870", "CVE-2007-2871");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1308] DSA-1308-1 iceweasel");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1308-1 iceweasel");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'firefox', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox is vulnerable in Debian 4.0.\nUpgrade to firefox_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'firefox-dom-inspector', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to firefox-dom-inspector_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'firefox-gnome-support', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to firefox-gnome-support_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian 4.0.\nUpgrade to iceweasel_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dbg', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dbg is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dbg_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dom-inspector', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dom-inspector_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-gnome-support', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-gnome-support is vulnerable in Debian 4.0.\nUpgrade to iceweasel-gnome-support_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-dom-inspector_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-gnome-support_2.0.0.4-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.4-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian etch.\nUpgrade to iceweasel_2.0.0.4-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
