# This script was automatically generated from the dsa-1310
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A vulnerability has been discovered in libexif, a library to parse EXIF
files, which allows denial of service and possible execution of arbitrary
code via malformed EXIF data.
For the old-stable distribution (sarge), this problem has been fixed
in version 0.6.9-6sarge1.
For the stable distribution (etch), this problem has been fixed in version
0.6.13-5etch1.
We recommend that you upgrade your libexif package.


Solution : http://www.debian.org/security/2007/dsa-1310
Risk factor : High';

if (description) {
 script_id(25532);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1310");
 script_cve_id("CVE-2006-4168");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1310] DSA-1310-1 libexif");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1310-1 libexif");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libexif-dev', release: '3.1', reference: '0.6.9-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif-dev is vulnerable in Debian 3.1.\nUpgrade to libexif-dev_0.6.9-6sarge1\n');
}
if (deb_check(prefix: 'libexif10', release: '3.1', reference: '0.6.9-6sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif10 is vulnerable in Debian 3.1.\nUpgrade to libexif10_0.6.9-6sarge1\n');
}
if (deb_check(prefix: 'libexif-dev', release: '4.0', reference: '0.6.13-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif-dev is vulnerable in Debian 4.0.\nUpgrade to libexif-dev_0.6.13-5etch1\n');
}
if (deb_check(prefix: 'libexif12', release: '4.0', reference: '0.6.13-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif12 is vulnerable in Debian 4.0.\nUpgrade to libexif12_0.6.13-5etch1\n');
}
if (deb_check(prefix: 'libexif', release: '4.0', reference: '0.6.13-5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libexif is vulnerable in Debian etch.\nUpgrade to libexif_0.6.13-5etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
