# This script was automatically generated from the dsa-1311
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the PostgreSQL database performs insufficient
validation of variables passed to privileged SQL statement called
<q>security definers</q>, which could lead to SQL privilege escalation.
For the oldstable distribution (sarge) this problem has been fixed in
version 7.4.7-6sarge5. A powerpc build is not yet available due to
problems with the build host. It will be provided later.
For the stable distribution (etch) this problem has been fixed in
version 7.4.17-0etch1.
For the unstable distribution (sid) this problem has been fixed in
version 7.4.17-1.
We recommend that you upgrade your PostgreSQL packages.


Solution : http://www.debian.org/security/2007/dsa-1311
Risk factor : High';

if (description) {
 script_id(25555);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1311");
 script_cve_id("CVE-2007-2138");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1311] DSA-1311-1 postgresql-7.4");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1311-1 postgresql-7.4");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libecpg-dev', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg-dev is vulnerable in Debian 3.1.\nUpgrade to libecpg-dev_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'libecpg4', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libecpg4 is vulnerable in Debian 3.1.\nUpgrade to libecpg4_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'libpgtcl', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtcl is vulnerable in Debian 3.1.\nUpgrade to libpgtcl_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'libpgtcl-dev', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpgtcl-dev is vulnerable in Debian 3.1.\nUpgrade to libpgtcl-dev_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'libpq3', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpq3 is vulnerable in Debian 3.1.\nUpgrade to libpq3_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'postgresql', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql is vulnerable in Debian 3.1.\nUpgrade to postgresql_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'postgresql-client', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-client is vulnerable in Debian 3.1.\nUpgrade to postgresql-client_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'postgresql-contrib', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-contrib is vulnerable in Debian 3.1.\nUpgrade to postgresql-contrib_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'postgresql-dev', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-dev is vulnerable in Debian 3.1.\nUpgrade to postgresql-dev_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'postgresql-doc', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-doc is vulnerable in Debian 3.1.\nUpgrade to postgresql-doc_7.4.7-6sarge5\n');
}
if (deb_check(prefix: 'postgresql-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-client-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-client-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-client-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-contrib-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-contrib-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-contrib-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-doc-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-doc-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-doc-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plperl-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plperl-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plperl-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-plpython-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-plpython-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-plpython-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-pltcl-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-pltcl-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-pltcl-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-server-dev-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-server-dev-7.4 is vulnerable in Debian 4.0.\nUpgrade to postgresql-server-dev-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-7.4', release: '4.0', reference: '7.4.17-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-7.4 is vulnerable in Debian etch.\nUpgrade to postgresql-7.4_7.4.17-0etch1\n');
}
if (deb_check(prefix: 'postgresql-7.4', release: '3.1', reference: '7.4.7-6sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package postgresql-7.4 is vulnerable in Debian sarge.\nUpgrade to postgresql-7.4_7.4.7-6sarge5\n');
}
if (w) { security_hole(port: 0, data: desc); }
