# This script was automatically generated from the dsa-1312
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that the Apache 1.3 connector for the Tomcat Java
servlet engine decoded request URLs multiple times, which can lead
to information disclosure.
For the oldstable distribution (sarge) this problem has been fixed in
version 1.2.5-2sarge1. An updated package for powerpc is not yet
available due to problems with the build host. It will be provided
later.
For the stable distribution (etch) this problem has been fixed in
version 1.2.18-3etch1.
For the unstable distribution (sid) this problem has been fixed in
version 1.2.23-1.
We recommend that you upgrade your libapache-mod-jk package.


Solution : http://www.debian.org/security/2007/dsa-1312
Risk factor : High';

if (description) {
 script_id(25556);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1312");
 script_cve_id("CVE-2007-1860");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1312] DSA-1312-1 libapache-mod-jk");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1312-1 libapache-mod-jk");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libapache-mod-jk', release: '3.1', reference: '1.2.5-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-jk is vulnerable in Debian 3.1.\nUpgrade to libapache-mod-jk_1.2.5-2sarge1\n');
}
if (deb_check(prefix: 'libapache-mod-jk', release: '4.0', reference: '1.2.18-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-jk is vulnerable in Debian 4.0.\nUpgrade to libapache-mod-jk_1.2.18-3etch1\n');
}
if (deb_check(prefix: 'libapache-mod-jk-doc', release: '4.0', reference: '1.2.18-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-jk-doc is vulnerable in Debian 4.0.\nUpgrade to libapache-mod-jk-doc_1.2.18-3etch1\n');
}
if (deb_check(prefix: 'libapache2-mod-jk', release: '4.0', reference: '1.2.18-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache2-mod-jk is vulnerable in Debian 4.0.\nUpgrade to libapache2-mod-jk_1.2.18-3etch1\n');
}
if (deb_check(prefix: 'libapache-mod-jk', release: '4.0', reference: '1.2.18-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-jk is vulnerable in Debian etch.\nUpgrade to libapache-mod-jk_1.2.18-3etch1\n');
}
if (deb_check(prefix: 'libapache-mod-jk', release: '3.1', reference: '1.2.5-2sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-jk is vulnerable in Debian sarge.\nUpgrade to libapache-mod-jk_1.2.5-2sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
