# This script was automatically generated from the dsa-1318
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in ekg, a console
Gadu Gadu client. The Common Vulnerabilities and Exposures project
identifies the following problems:
    It was discovered that memory alignment errors may allow remote
    attackers to cause a denial of service on certain architectures
    such as sparc. This only affects Debian Sarge.
    It was discovered that several endianess errors may allow remote
    attackers to cause a denial of service. This only affects 
    Debian Sarge.
    It was discovered that a memory leak in handling image messages may
    lead to denial of service. This only affects Debian Etch.
    It was discovered that a null pointer deference in the token OCR code
    may lead to denial of service. This only affects Debian Etch.
    It was discovered that a memory leak in the token OCR code may lead
    to denial of service. This only affects Debian Etch.
For the oldstable distribution (sarge) these problems have been fixed in
version 1.5+20050411-7. This updates lacks updated packages for the m68k
architecture. They will be provided later.
For the stable distribution (etch) these problems have been fixed
in version 1:1.7~rc2-1etch1.
For the unstable distribution (sid) these problems have been fixed in
version 1:1.7~rc2-2.
We recommend that you upgrade your ekg packages.


Solution : http://www.debian.org/security/2007/dsa-1318
Risk factor : High';

if (description) {
 script_id(25584);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1318");
 script_cve_id("CVE-2005-2370", "CVE-2005-2448", "CVE-2007-1663", "CVE-2007-1664", "CVE-2007-1665");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1318] DSA-1318-1 ekg");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1318-1 ekg");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'ekg', release: '3.1', reference: '1.5+20050411-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ekg is vulnerable in Debian 3.1.\nUpgrade to ekg_1.5+20050411-7\n');
}
if (deb_check(prefix: 'libgadu-dev', release: '3.1', reference: '1.5+20050411-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgadu-dev is vulnerable in Debian 3.1.\nUpgrade to libgadu-dev_1.5+20050411-7\n');
}
if (deb_check(prefix: 'libgadu3', release: '3.1', reference: '1.5+20050411-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libgadu3 is vulnerable in Debian 3.1.\nUpgrade to libgadu3_1.5+20050411-7\n');
}
if (deb_check(prefix: 'ekg', release: '4.0', reference: '1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ekg is vulnerable in Debian etch.\nUpgrade to ekg_1\n');
}
if (deb_check(prefix: 'ekg', release: '3.1', reference: '1.5+20050411-7')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ekg is vulnerable in Debian sarge.\nUpgrade to ekg_1.5+20050411-7\n');
}
if (w) { security_hole(port: 0, data: desc); }
