# This script was automatically generated from the dsa-1320
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Clam anti-virus
toolkit. The Common Vulnerabilities and Exposures project identifies the
following problems:
    It was discovered that the OLE2 parser can be tricked into an infinite
    loop and memory exhaustion.
    It was discovered that the NsPack decompression code performed
    insufficient sanitising on an internal length variable, resulting in
    a potential buffer overflow.
    It was discovered that temporary files were created with insecure
    permissions, resulting in information disclosure.
    It was discovered that the decompression code for RAR archives allows
    bypassing a scan of a RAR archive due to insufficient validity checks.
    It was discovered that the decompression code for RAR archives performs
    insufficient validation of header values, resulting in a buffer overflow.
For the oldstable distribution (sarge) these problems have been fixed in
version 0.84-2.sarge.17. Please note that the fix for CVE-2007-3024 hasn\'t
been backported to oldstable.
For the stable distribution (etch) these problems have been fixed
in version 0.90.1-3etch1.
For the unstable distribution (sid) these problems have been fixed in
version 0.90.2-1.
We recommend that you upgrade your clamav packages. An updated package
for oldstable/powerpc is not yet available. It will be provided later.


Solution : http://www.debian.org/security/2007/dsa-1320
Risk factor : High';

if (description) {
 script_id(25586);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1320");
 script_cve_id("CVE-2007-2650", "CVE-2007-3023", "CVE-2007-3024", "CVE-2007-3122", "CVE-2007-3123");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1320] DSA-1320-1 clamav");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1320-1 clamav");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'clamav', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav is vulnerable in Debian 3.1.\nUpgrade to clamav_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'clamav-base', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-base is vulnerable in Debian 3.1.\nUpgrade to clamav-base_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'clamav-daemon', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-daemon is vulnerable in Debian 3.1.\nUpgrade to clamav-daemon_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'clamav-docs', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-docs is vulnerable in Debian 3.1.\nUpgrade to clamav-docs_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'clamav-freshclam', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-freshclam is vulnerable in Debian 3.1.\nUpgrade to clamav-freshclam_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'clamav-milter', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-milter is vulnerable in Debian 3.1.\nUpgrade to clamav-milter_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'clamav-testfiles', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-testfiles is vulnerable in Debian 3.1.\nUpgrade to clamav-testfiles_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'libclamav-dev', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libclamav-dev is vulnerable in Debian 3.1.\nUpgrade to libclamav-dev_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'libclamav1', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libclamav1 is vulnerable in Debian 3.1.\nUpgrade to libclamav1_0.84-2.sarge.17\n');
}
if (deb_check(prefix: 'clamav', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav is vulnerable in Debian 4.0.\nUpgrade to clamav_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav-base', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-base is vulnerable in Debian 4.0.\nUpgrade to clamav-base_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav-daemon', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-daemon is vulnerable in Debian 4.0.\nUpgrade to clamav-daemon_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav-dbg', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-dbg is vulnerable in Debian 4.0.\nUpgrade to clamav-dbg_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav-docs', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-docs is vulnerable in Debian 4.0.\nUpgrade to clamav-docs_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav-freshclam', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-freshclam is vulnerable in Debian 4.0.\nUpgrade to clamav-freshclam_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav-milter', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-milter is vulnerable in Debian 4.0.\nUpgrade to clamav-milter_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav-testfiles', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-testfiles is vulnerable in Debian 4.0.\nUpgrade to clamav-testfiles_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'libclamav-dev', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libclamav-dev is vulnerable in Debian 4.0.\nUpgrade to libclamav-dev_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'libclamav2', release: '4.0', reference: '0.90.1-3etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libclamav2 is vulnerable in Debian 4.0.\nUpgrade to libclamav2_0.90.1-3etch3\n');
}
if (deb_check(prefix: 'clamav', release: '4.0', reference: '0.90.1-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav is vulnerable in Debian etch.\nUpgrade to clamav_0.90.1-3etch1\n');
}
if (deb_check(prefix: 'clamav', release: '3.1', reference: '0.84-2.sarge.17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav is vulnerable in Debian sarge.\nUpgrade to clamav_0.84-2.sarge.17\n');
}
if (w) { security_hole(port: 0, data: desc); }
