# This script was automatically generated from the dsa-1326
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Steve Kemp from the Debian Security Audit project discovered that 
fireflier-server, an interactive firewall rule creation tool, uses temporary 
files in an unsafe manner which may be exploited to remove arbitrary files from 
the local system.
For the old stable distribution (sarge) this problem has been fixed in
version 1.1.5-1sarge1.
For the stable distribution (etch) this problem has been fixed in
version 1.1.6-3etch1.
For the unstable distribution (sid) this problem will be fixed shortly.
We recommend that you upgrade your fireflier-server package.


Solution : http://www.debian.org/security/2007/dsa-1326
Risk factor : High';

if (description) {
 script_id(25638);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1326");
 script_cve_id("CVE-2007-2837");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1326] DSA-1326-1 fireflier-server");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1326-1 fireflier-server");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'fireflier-client-gtk', release: '4.0', reference: '1.1.6-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fireflier-client-gtk is vulnerable in Debian 4.0.\nUpgrade to fireflier-client-gtk_1.1.6-3etch1\n');
}
if (deb_check(prefix: 'fireflier-client-kde', release: '4.0', reference: '1.1.6-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fireflier-client-kde is vulnerable in Debian 4.0.\nUpgrade to fireflier-client-kde_1.1.6-3etch1\n');
}
if (deb_check(prefix: 'fireflier-client-qt', release: '4.0', reference: '1.1.6-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fireflier-client-qt is vulnerable in Debian 4.0.\nUpgrade to fireflier-client-qt_1.1.6-3etch1\n');
}
if (deb_check(prefix: 'fireflier-server', release: '4.0', reference: '1.1.6-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fireflier-server is vulnerable in Debian 4.0.\nUpgrade to fireflier-server_1.1.6-3etch1\n');
}
if (deb_check(prefix: 'fireflier-server', release: '4.0', reference: '1.1.6-3etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fireflier-server is vulnerable in Debian etch.\nUpgrade to fireflier-server_1.1.6-3etch1\n');
}
if (deb_check(prefix: 'fireflier-server', release: '3.1', reference: '1.1.5-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package fireflier-server is vulnerable in Debian sarge.\nUpgrade to fireflier-server_1.1.5-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
