# This script was automatically generated from the dsa-1329
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Steve Kemp from the Debian Security Audit project discovered that
gfax, a GNOME frontend for fax programs, uses temporary files in an
unsafe manner which may be exploited to execute arbitrary commands
with the privileges of the root user.
For the old stable distribution (sarge) this problem has been fixed
in version 0.4.2-11sarge1.
The stable distribution (etch) is not affected by this problem.
The unstable distribution (sid) is not affected by this problem.
We recommend that you upgrade your gfax package.


Solution : http://www.debian.org/security/2007/dsa-1329
Risk factor : High';

if (description) {
 script_id(25676);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1329");
 script_cve_id("CVE-2007-2839");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1329] DSA-1329-1 gfax");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1329-1 gfax");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'gfax', release: '3.1', reference: '0.4.2-11sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gfax is vulnerable in Debian 3.1.\nUpgrade to gfax_0.4.2-11sarge1\n');
}
if (deb_check(prefix: 'gfax', release: '3.1', reference: '0.4.2-11sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package gfax is vulnerable in Debian sarge.\nUpgrade to gfax_0.4.2-11sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
