# This script was automatically generated from the dsa-1336
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in Mozilla Firefox.
This will be the last security update of Mozilla-based products for
the oldstable (sarge) distribution of Debian. We recommend to upgrade
to stable (etch) as soon as possible.
The Common Vulnerabilities and Exposures project identifies the following
vulnerabilities:
    It was discovered that an integer overflow in text/enhanced message
    parsing allows the execution of arbitrary code.
    It was discovered that a regression in the Javascript engine allows
    the execution of Javascript with elevated privileges.
    It was discovered that incorrect parsing of invalid HTML characters
    allows the bypass of content filters.
    It was discovered that insecure child frame handling allows cross-site
    scripting.
    It was discovered that Firefox handles URI with a null byte in the
    hostname insecurely.
    It was discovered that a buffer overflow in the NSS code allows the
    execution of arbitrary code.
    It was discovered that a buffer overflow in the NSS code allows the
    execution of arbitrary code.
    It was discovered that multiple programming errors in the layout engine
    allow the execution of arbitrary code.
    It was discovered that the page cache calculates hashes in an insecure
    manner.
    It was discovered that the password manager allows the disclosure of
    passwords.
For the oldstable distribution (sarge) these problems have been fixed in
version 1.0.4-2sarge17. You should upgrade to etch as soon as possible.
The stable distribution (etch) isn\'t affected. These vulnerabilities have
been fixed prior to the release of Debian etch.
The unstable distribution (sid) no longer contains mozilla-firefox. Iceweasel
is already fixed.


Solution : http://www.debian.org/security/2007/dsa-1336
Risk factor : High';

if (description) {
 script_id(25779);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1336");
 script_cve_id("CVE-2006-6077", "CVE-2007-0008", "CVE-2007-0009", "CVE-2007-0045", "CVE-2007-0775", "CVE-2007-0778", "CVE-2007-0981");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1336] DSA-1336-1 mozilla-firefox");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1336-1 mozilla-firefox");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'mozilla-firefox', release: '3.1', reference: '1.0.4-2sarge17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox_1.0.4-2sarge17\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '3.1', reference: '1.0.4-2sarge17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox-dom-inspector_1.0.4-2sarge17\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '3.1', reference: '1.0.4-2sarge17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 3.1.\nUpgrade to mozilla-firefox-gnome-support_1.0.4-2sarge17\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '3.1', reference: '1.0.4-2sarge17')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian sarge.\nUpgrade to mozilla-firefox_1.0.4-2sarge17\n');
}
if (w) { security_hole(port: 0, data: desc); }
