# This script was automatically generated from the dsa-1338
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common 
Vulnerabilities and Exposures project identifies the following problems:
    Ronen Zilberman and Michal Zalewski discovered that a timing race
    allows the injection of content into about:blank frames.
    Michal Zalewski discovered that same-origin policies for wyciwyg://
    documents are insufficiently enforced.
    Bernd Mielke, Boris Zbarsky, David Baron, Daniel Veditz, Jesse Ruderman,
    Lukas Loehrer, Martijn Wargers, Mats Palmgren, Olli Pettay, Paul
    Nickerson and Vladimir Sukhoy discovered crashes in the layout engine,
    which might allow the execution of arbitrary code.
    Asaf Romano, Jesse Ruderman and Igor Bukanov discovered crashes in the
    javascript engine, which might allow the execution of arbitrary code.
    <q>moz_bug_r_a4</q> discovered that the addEventListener() and setTimeout()
    functions allow cross-site scripting.
    <q>moz_bug_r_a4</q> discovered that a programming error in event handling
    allows privilege escalation.
    <q>shutdown</q> and <q>moz_bug_r_a4</q> discovered that the XPCNativeWrapper allows
    the execution of arbitrary code.
The Mozilla products in the oldstable distribution (sarge) are no longer
supported with security updates. You\'re strongly encouraged to upgrade to
stable as soon as possible.
For the stable distribution (etch) these problems have been fixed in version
2.0.0.5-0etch1. Builds for alpha and mips are not yet available, they will
be provided later.
For the unstable distribution (sid) these problems have been fixed in version
2.0.0.5-1.
We recommend that you upgrade your iceweasel packages.


Solution : http://www.debian.org/security/2007/dsa-1338
Risk factor : High';

if (description) {
 script_id(25781);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1338");
 script_cve_id("CVE-2007-3089", "CVE-2007-3656", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737", "CVE-2007-3738");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1338] DSA-1338-1 iceweasel");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1338-1 iceweasel");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'firefox', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox is vulnerable in Debian 4.0.\nUpgrade to firefox_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'firefox-dom-inspector', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to firefox-dom-inspector_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'firefox-gnome-support', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to firefox-gnome-support_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian 4.0.\nUpgrade to iceweasel_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dbg', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dbg is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dbg_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dom-inspector', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dom-inspector_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-gnome-support', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-gnome-support is vulnerable in Debian 4.0.\nUpgrade to iceweasel-gnome-support_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-dom-inspector_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-gnome-support_2.0.0.5-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.5-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian etch.\nUpgrade to iceweasel_2.0.0.5-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
