# This script was automatically generated from the dsa-1339
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceape internet
suite, an unbranded version of the Seamonkey Internet Suite. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Ronen Zilberman and Michal Zalewski discovered that a timing race
    allows the injection of content into about:blank frames.
    Michal Zalewski discovered that same-origin policies for wyciwyg://
    documents are insufficiently enforced.
    Bernd Mielke, Boris Zbarsky, David Baron, Daniel Veditz, Jesse Ruderman,
    Lukas Loehrer, Martijn Wargers, Mats Palmgren, Olli Pettay, Paul
    Nickerson and Vladimir Sukhoy discovered crashes in the layout engine,
    which might allow the execution of arbitrary code.
    Asaf Romano, Jesse Ruderman and Igor Bukanov discovered crashes in the
    javascript engine, which might allow the execution of arbitrary code.
    <q>moz_bug_r_a4</q> discovered that the addEventListener() and setTimeout()
    functions allow cross-site scripting.
    <q>moz_bug_r_a4</q> discovered that a programming error in event handling
    allows privilege escalation.
    <q>shutdown</q> and <q>moz_bug_r_a4</q> discovered that the XPCNativeWrapper allows
    the execution of arbitrary code.
The Mozilla products in the oldstable distribution (sarge) are no longer
supported with security updates. You\'re strongly encouraged to upgrade to
stable as soon as possible.
For the stable distribution (etch) these problems have been fixed in version
1.0.10~pre070720-0etch1. A build for the mips architecture is not yet available,
it will be provided later.
For the unstable distribution (sid) these problems have been fixed in version
1.1.3-1.
We recommend that you upgrade your iceape packages.


Solution : http://www.debian.org/security/2007/dsa-1339
Risk factor : High';

if (description) {
 script_id(25801);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1339");
 script_cve_id("CVE-2007-3089", "CVE-2007-3656", "CVE-2007-3734", "CVE-2007-3735", "CVE-2007-3736", "CVE-2007-3737", "CVE-2007-3738");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1339] DSA-1339-1 iceape");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1339-1 iceape");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'iceape', release: '4.0', reference: '1.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape is vulnerable in Debian etch.\nUpgrade to iceape_1.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
