# This script was automatically generated from the dsa-1340
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A NULL pointer dereference has been discovered in the RAR VM of Clam
Antivirus (ClamAV) which allows user-assisted remote attackers to
cause a denial of service via a specially crafted RAR archives.
We are currently unable to provide fixed packages for the MIPS
architectures.  Those packages will be installed in the security
archive when they become available.
The old stable distribution (sarge) is not affected by this problem.
For the stable distribution (etch) this problem has been fixed in
version 0.90.1-3etch4.
For the unstable distribution (sid) this problem has been fixed in
version 0.91-1.
We recommend that you upgrade your clamav packages.


Solution : http://www.debian.org/security/2007/dsa-1340
Risk factor : High';

if (description) {
 script_id(25782);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1340");
 script_cve_id("CVE-2007-3725");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1340] DSA-1340-1 clamav");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1340-1 clamav");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'clamav', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav is vulnerable in Debian 4.0.\nUpgrade to clamav_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav-base', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-base is vulnerable in Debian 4.0.\nUpgrade to clamav-base_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav-daemon', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-daemon is vulnerable in Debian 4.0.\nUpgrade to clamav-daemon_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav-dbg', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-dbg is vulnerable in Debian 4.0.\nUpgrade to clamav-dbg_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav-docs', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-docs is vulnerable in Debian 4.0.\nUpgrade to clamav-docs_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav-freshclam', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-freshclam is vulnerable in Debian 4.0.\nUpgrade to clamav-freshclam_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav-milter', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-milter is vulnerable in Debian 4.0.\nUpgrade to clamav-milter_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav-testfiles', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav-testfiles is vulnerable in Debian 4.0.\nUpgrade to clamav-testfiles_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'libclamav-dev', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libclamav-dev is vulnerable in Debian 4.0.\nUpgrade to libclamav-dev_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'libclamav2', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libclamav2 is vulnerable in Debian 4.0.\nUpgrade to libclamav2_0.90.1-3etch4\n');
}
if (deb_check(prefix: 'clamav', release: '4.0', reference: '0.90.1-3etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package clamav is vulnerable in Debian etch.\nUpgrade to clamav_0.90.1-3etch4\n');
}
if (w) { security_hole(port: 0, data: desc); }
