# This script was automatically generated from the dsa-1343
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Colin Percival discovered an integer overflow in file, a file type
classification tool, which may lead to the execution of arbitrary code.
For the oldstable distribution (sarge) this problem has been fixed in
version 4.12-1sarge2.
For the stable distribution (etch) this problem has been fixed in
version 4.17-5etch2.
For the unstable distribution (sid) this problem has been fixed in
version 4.21-1.
We recommend that you upgrade your file package.


Solution : http://www.debian.org/security/2007/dsa-1343
Risk factor : High';

if (description) {
 script_id(25826);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1343");
 script_cve_id("CVE-2007-2799");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1343] DSA-1343-1 file");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1343-1 file");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'file', release: '3.1', reference: '4.12-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian 3.1.\nUpgrade to file_4.12-1sarge2\n');
}
if (deb_check(prefix: 'libmagic-dev', release: '3.1', reference: '4.12-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic-dev is vulnerable in Debian 3.1.\nUpgrade to libmagic-dev_4.12-1sarge2\n');
}
if (deb_check(prefix: 'libmagic1', release: '3.1', reference: '4.12-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic1 is vulnerable in Debian 3.1.\nUpgrade to libmagic1_4.12-1sarge2\n');
}
if (deb_check(prefix: 'file', release: '4.0', reference: '4.17-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian 4.0.\nUpgrade to file_4.17-5etch2\n');
}
if (deb_check(prefix: 'libmagic-dev', release: '4.0', reference: '4.17-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic-dev is vulnerable in Debian 4.0.\nUpgrade to libmagic-dev_4.17-5etch2\n');
}
if (deb_check(prefix: 'libmagic1', release: '4.0', reference: '4.17-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmagic1 is vulnerable in Debian 4.0.\nUpgrade to libmagic1_4.17-5etch2\n');
}
if (deb_check(prefix: 'python-magic', release: '4.0', reference: '4.17-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package python-magic is vulnerable in Debian 4.0.\nUpgrade to python-magic_4.17-5etch2\n');
}
if (deb_check(prefix: 'file', release: '4.0', reference: '4.17-5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian etch.\nUpgrade to file_4.17-5etch2\n');
}
if (deb_check(prefix: 'file', release: '3.1', reference: '4.12-1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package file is vulnerable in Debian sarge.\nUpgrade to file_4.12-1sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
