# This script was automatically generated from the dsa-1346
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in the Iceape internet
suite, an unbranded version of the Seamonkey Internet Suite. The Common
Vulnerabilities and Exposures project identifies the following problems:
    <q>moz_bug_r_a4</q> discovered that a regression in the handling of
    <q>about:blank</q> windows used by addons may lead to an attacker being
    able to modify the content of web sites.
    Jesper Johansson discovered that missing sanitising of double-quotes
    and spaces in URIs passed to external programs may allow an attacker
    to pass arbitrary arguments to the helper program if the user is
    tricked into opening a malformed web page.
The Mozilla products in the oldstable distribution (sarge) are no longer
supported with security updates.
For the stable distribution (etch) these problems have been fixed in version
1.0.10~pre070720-0etch3.
For the unstable distribution (sid) these problems have been fixed in version
1.1.3-2.
We recommend that you upgrade your iceape packages.


Solution : http://www.debian.org/security/2007/dsa-1346
Risk factor : High';

if (description) {
 script_id(25854);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1346");
 script_cve_id("CVE-2007-3844", "CVE-2007-3845");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1346] DSA-1346-1 iceape");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1346-1 iceape");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'iceape', release: '4.0', reference: '1.0')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceape is vulnerable in Debian etch.\nUpgrade to iceape_1.0\n');
}
if (w) { security_hole(port: 0, data: desc); }
