# This script was automatically generated from the dsa-1353
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that an integer overflow in the BGP dissector of tcpdump,
a powerful tool for network monitoring and data acquisition, may lead to
the execution of arbitrary code.
For the oldstable distribution (sarge) this problem has been fixed in
version 3.8.3-5sarge3.
For the stable distribution (etch) this problem has been fixed in
version 3.9.5-2etch1.
For the unstable distribution (sid) this problem has been fixed in
version 3.9.5-3.
We recommend that you upgrade your tcpdump package.


Solution : http://www.debian.org/security/2007/dsa-1353
Risk factor : High';

if (description) {
 script_id(25861);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1353");
 script_cve_id("CVE-2007-3798");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1353] DSA-1353-1 tcpdump");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1353-1 tcpdump");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'tcpdump', release: '3.1', reference: '3.8.3-5sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tcpdump is vulnerable in Debian 3.1.\nUpgrade to tcpdump_3.8.3-5sarge3\n');
}
if (deb_check(prefix: 'tcpdump', release: '4.0', reference: '3.9.5-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tcpdump is vulnerable in Debian 4.0.\nUpgrade to tcpdump_3.9.5-2etch1\n');
}
if (deb_check(prefix: 'tcpdump', release: '4.0', reference: '3.9.5-2etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tcpdump is vulnerable in Debian etch.\nUpgrade to tcpdump_3.9.5-2etch1\n');
}
if (deb_check(prefix: 'tcpdump', release: '3.1', reference: '3.8.3-5sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package tcpdump is vulnerable in Debian sarge.\nUpgrade to tcpdump_3.8.3-5sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
