# This script was automatically generated from the dsa-1362
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities were discovered in lighttpd, a fast webserver with
minimal memory footprint, which could allow the execution of arbitary code via
the overflow of CGI variables when mod_fcgi was enabled.  The Common
Vulnerabilities and Exposures project identifies the following problems:
    The use of mod_auth could leave to a denial of service attack crashing
    the webserver.
    The improper handling of repeated HTTP headers could cause a denial
    of service attack crashing the webserver.
    A bug in mod_access potentially allows remote users to bypass
    access restrictions via trailing slash characters.
    On 32-bit platforms users may be able to create denial of service
    attacks, crashing the webserver, via mod_webdav, mod_fastcgi, or
    mod_scgi.
For the stable distribution (etch), these problems have been fixed in version
1.4.13-4etch4.
For the unstable distribution (sid), these problems have been fixed in
version 1.4.16-1.
We recommend that you upgrade your lighttpd package.


Solution : http://www.debian.org/security/2007/dsa-1362
Risk factor : High';

if (description) {
 script_id(25962);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1362");
 script_cve_id("CVE-2007-3946", "CVE-2007-3947", "CVE-2007-3949", "CVE-2007-3950", "CVE-2007-4727");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1362] DSA-1362-2 lighttpd");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1362-2 lighttpd");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'lighttpd', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd is vulnerable in Debian 4.0.\nUpgrade to lighttpd_1.4.13-4etch4\n');
}
if (deb_check(prefix: 'lighttpd-doc', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-doc is vulnerable in Debian 4.0.\nUpgrade to lighttpd-doc_1.4.13-4etch4\n');
}
if (deb_check(prefix: 'lighttpd-mod-cml', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-cml is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-cml_1.4.13-4etch4\n');
}
if (deb_check(prefix: 'lighttpd-mod-magnet', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-magnet is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-magnet_1.4.13-4etch4\n');
}
if (deb_check(prefix: 'lighttpd-mod-mysql-vhost', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-mysql-vhost is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-mysql-vhost_1.4.13-4etch4\n');
}
if (deb_check(prefix: 'lighttpd-mod-trigger-b4-dl', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-trigger-b4-dl is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-trigger-b4-dl_1.4.13-4etch4\n');
}
if (deb_check(prefix: 'lighttpd-mod-webdav', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd-mod-webdav is vulnerable in Debian 4.0.\nUpgrade to lighttpd-mod-webdav_1.4.13-4etch4\n');
}
if (deb_check(prefix: 'lighttpd', release: '4.0', reference: '1.4.13-4etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package lighttpd is vulnerable in Debian etch.\nUpgrade to lighttpd_1.4.13-4etch4\n');
}
if (w) { security_hole(port: 0, data: desc); }
