# This script was automatically generated from the dsa-1364
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities have been discovered in the vim editor. The Common
Vulnerabilities and Exposures project identifies the following problems:
    Ulf Hrnhammar discovered that a format string flaw in helptags_one() from
    src/ex_cmds.c (triggered through the <q>helptags</q> command) can lead to the
    execution of arbitrary code.
    Editors often provide a way to embed editor configuration commands (aka
    modelines) which are executed once a file is opened. Harmful commands
    are filtered by a sandbox mechanism. It was discovered that function
    calls to writefile(), feedkeys() and system() were not filtered, allowing
    shell command execution with a carefully crafted file opened in vim.
This updated advisory repairs issues with missing files in the packages
for the oldstable distribution (sarge) for the alpha, mips, and mipsel
architectures.
For the oldstable distribution (sarge) these problems have been fixed in
version 6.3-071+1sarge2. Sarge is not affected by CVE-2007-2438.
For the stable distribution (etch) these problems have been fixed
in version 7.0-122+1etch3.
For the unstable distribution (sid) these problems have been fixed in
version 7.1-056+1.
We recommend that you upgrade your vim packages.


Solution : http://www.debian.org/security/2007/dsa-1364
Risk factor : High';

if (description) {
 script_id(25964);
 script_version("$Revision: 1.4 $");
 script_xref(name: "DSA", value: "1364");
 script_cve_id("CVE-2007-2438", "CVE-2007-2953");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1364] DSA-1364-2 vim");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1364-2 vim");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'vim', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim is vulnerable in Debian 3.1.\nUpgrade to vim_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-common', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-common is vulnerable in Debian 3.1.\nUpgrade to vim-common_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-doc', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-doc is vulnerable in Debian 3.1.\nUpgrade to vim-doc_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-full', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-full is vulnerable in Debian 3.1.\nUpgrade to vim-full_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-gnome', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-gnome is vulnerable in Debian 3.1.\nUpgrade to vim-gnome_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-gtk', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-gtk is vulnerable in Debian 3.1.\nUpgrade to vim-gtk_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-lesstif', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-lesstif is vulnerable in Debian 3.1.\nUpgrade to vim-lesstif_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-perl', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-perl is vulnerable in Debian 3.1.\nUpgrade to vim-perl_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-python', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-python is vulnerable in Debian 3.1.\nUpgrade to vim-python_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-ruby', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-ruby is vulnerable in Debian 3.1.\nUpgrade to vim-ruby_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim-tcl', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-tcl is vulnerable in Debian 3.1.\nUpgrade to vim-tcl_6.3-071+1sarge2\n');
}
if (deb_check(prefix: 'vim', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim is vulnerable in Debian 4.0.\nUpgrade to vim_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-common', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-common is vulnerable in Debian 4.0.\nUpgrade to vim-common_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-doc', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-doc is vulnerable in Debian 4.0.\nUpgrade to vim-doc_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-full', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-full is vulnerable in Debian 4.0.\nUpgrade to vim-full_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-gnome', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-gnome is vulnerable in Debian 4.0.\nUpgrade to vim-gnome_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-gtk', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-gtk is vulnerable in Debian 4.0.\nUpgrade to vim-gtk_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-gui-common', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-gui-common is vulnerable in Debian 4.0.\nUpgrade to vim-gui-common_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-lesstif', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-lesstif is vulnerable in Debian 4.0.\nUpgrade to vim-lesstif_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-perl', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-perl is vulnerable in Debian 4.0.\nUpgrade to vim-perl_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-python', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-python is vulnerable in Debian 4.0.\nUpgrade to vim-python_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-ruby', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-ruby is vulnerable in Debian 4.0.\nUpgrade to vim-ruby_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-runtime', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-runtime is vulnerable in Debian 4.0.\nUpgrade to vim-runtime_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-tcl', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-tcl is vulnerable in Debian 4.0.\nUpgrade to vim-tcl_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim-tiny', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim-tiny is vulnerable in Debian 4.0.\nUpgrade to vim-tiny_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim', release: '4.0', reference: '7.0-122+1etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim is vulnerable in Debian etch.\nUpgrade to vim_7.0-122+1etch3\n');
}
if (deb_check(prefix: 'vim', release: '3.1', reference: '6.3-071+1sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package vim is vulnerable in Debian sarge.\nUpgrade to vim_6.3-071+1sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
