# This script was automatically generated from the dsa-1379
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
An off-by-one error has been identified in the SSL_get_shared_ciphers()
routine in the libssl library from OpenSSL, an implementation of Secure
Socket Layer cryptographic libraries and utilities.  This error could
allow an attacker to crash an application making use of OpenSSL\'s libssl
library, or potentially execute arbitrary code in the security context
of the user running such an application.

For the old stable distribution (sarge), this problem has been fixed in version
0.9.7e-3sarge5.


For the stable distribution (etch), this problem has been fixed in
version 0.9.8c-4etch1.


For the unstable and testing distributions (sid and lenny, respectively),
this problem has been fixed in version 0.9.8e-9.

We recommend that you upgrade your openssl packages.


Solution : http://www.debian.org/security/2007/dsa-1379
Risk factor : High';

if (description) {
 script_id(26209);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1379");
 script_cve_id("CVE-2007-5135");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1379] DSA-1379-1 openssl");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1379-1 openssl");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libssl-dev', release: '3.1', reference: '0.9.7e-3sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libssl-dev is vulnerable in Debian 3.1.\nUpgrade to libssl-dev_0.9.7e-3sarge5\n');
}
if (deb_check(prefix: 'libssl0.9.7', release: '3.1', reference: '0.9.7e-3sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libssl0.9.7 is vulnerable in Debian 3.1.\nUpgrade to libssl0.9.7_0.9.7e-3sarge5\n');
}
if (deb_check(prefix: 'openssl', release: '3.1', reference: '0.9.7e-3sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openssl is vulnerable in Debian 3.1.\nUpgrade to openssl_0.9.7e-3sarge5\n');
}
if (deb_check(prefix: 'libssl-dev', release: '4.0', reference: '0.9.8c-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libssl-dev is vulnerable in Debian 4.0.\nUpgrade to libssl-dev_0.9.8c-4etch1\n');
}
if (deb_check(prefix: 'libssl0.9.8', release: '4.0', reference: '0.9.8c-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libssl0.9.8 is vulnerable in Debian 4.0.\nUpgrade to libssl0.9.8_0.9.8c-4etch1\n');
}
if (deb_check(prefix: 'libssl0.9.8-dbg', release: '4.0', reference: '0.9.8c-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libssl0.9.8-dbg is vulnerable in Debian 4.0.\nUpgrade to libssl0.9.8-dbg_0.9.8c-4etch1\n');
}
if (deb_check(prefix: 'openssl', release: '4.0', reference: '0.9.8c-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openssl is vulnerable in Debian 4.0.\nUpgrade to openssl_0.9.8c-4etch1\n');
}
if (deb_check(prefix: 'openssl', release: '4.0', reference: '0.9.8c-4etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openssl is vulnerable in Debian etch.\nUpgrade to openssl_0.9.8c-4etch1\n');
}
if (deb_check(prefix: 'openssl', release: '3.1', reference: '0.9.7e-3sarge5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openssl is vulnerable in Debian sarge.\nUpgrade to openssl_0.9.7e-3sarge5\n');
}
if (w) { security_hole(port: 0, data: desc); }
