# This script was automatically generated from the dsa-1382
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It was discovered that BGP peers can trigger a NULL pointer dereference
in the BGP daemon if debug logging is enabled, causing the BGP daemon to
crash.
For the old stable distribution (sarge), this problem has been fixed in
version 0.98.3-7.5.
For the stable distribution (etch), this problem has been fixed in
version 0.99.5-5etch3.
For the unstable distribution (sid), this problem has been fixed in
version 0.99.9-1.
We recommend that you upgrade your quagga packages.


Solution : http://www.debian.org/security/2007/dsa-1382
Risk factor : High';

if (description) {
 script_id(26975);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1382");
 script_cve_id("CVE-2007-4826");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1382] DSA-1382-1 quagga");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1382-1 quagga");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'quagga', release: '3.1', reference: '0.98.3-7.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package quagga is vulnerable in Debian 3.1.\nUpgrade to quagga_0.98.3-7.5\n');
}
if (deb_check(prefix: 'quagga-doc', release: '3.1', reference: '0.98.3-7.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package quagga-doc is vulnerable in Debian 3.1.\nUpgrade to quagga-doc_0.98.3-7.5\n');
}
if (deb_check(prefix: 'quagga', release: '4.0', reference: '0.99.5-5etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package quagga is vulnerable in Debian 4.0.\nUpgrade to quagga_0.99.5-5etch3\n');
}
if (deb_check(prefix: 'quagga-doc', release: '4.0', reference: '0.99.5-5etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package quagga-doc is vulnerable in Debian 4.0.\nUpgrade to quagga-doc_0.99.5-5etch3\n');
}
if (deb_check(prefix: 'quagga', release: '4.0', reference: '0.99.5-5etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package quagga is vulnerable in Debian etch.\nUpgrade to quagga_0.99.5-5etch3\n');
}
if (deb_check(prefix: 'quagga', release: '3.1', reference: '0.98.3-7.5')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package quagga is vulnerable in Debian sarge.\nUpgrade to quagga_0.98.3-7.5\n');
}
if (w) { security_hole(port: 0, data: desc); }
