# This script was automatically generated from the dsa-1384
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '

Several local vulnerabilities have been discovered in the Xen hypervisor
packages which may lead to the execution of arbitrary code. The Common
Vulnerabilities and Exposures project identifies the following problems:
   By use of a specially crafted grub configuration file a domU user
  may be able to execute arbitrary code upon the dom0 when pygrub is
  being used.
   Multiple heap-based buffer overflows in the Cirrus VGA extension,
  provided by QEMU, may allow local users to execute arbitrary code
  via <q>bitblt</q> heap overflow.
For the stable distribution (etch), these problems have been fixed in version
3.0.3-0-3.
For the unstable distribution (sid), these problems will be fixed soon.
We recommend that you upgrade your xen-utils package.


Solution : http://www.debian.org/security/2007/dsa-1384
Risk factor : High';

if (description) {
 script_id(26931);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1384");
 script_cve_id("CVE-2007-1320", "CVE-2007-4993");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1384] DSA-1384-1 xen-utils");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1384-1 xen-utils");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'xen-docs-3.0', release: '4.0', reference: '3.0.3-0-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-docs-3.0 is vulnerable in Debian 4.0.\nUpgrade to xen-docs-3.0_3.0.3-0-3\n');
}
if (deb_check(prefix: 'xen-hypervisor-3.0.3-1-amd64', release: '4.0', reference: '3.0.3-0-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-hypervisor-3.0.3-1-amd64 is vulnerable in Debian 4.0.\nUpgrade to xen-hypervisor-3.0.3-1-amd64_3.0.3-0-3\n');
}
if (deb_check(prefix: 'xen-hypervisor-3.0.3-1-i386', release: '4.0', reference: '3.0.3-0-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-hypervisor-3.0.3-1-i386 is vulnerable in Debian 4.0.\nUpgrade to xen-hypervisor-3.0.3-1-i386_3.0.3-0-3\n');
}
if (deb_check(prefix: 'xen-hypervisor-3.0.3-1-i386-pae', release: '4.0', reference: '3.0.3-0-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-hypervisor-3.0.3-1-i386-pae is vulnerable in Debian 4.0.\nUpgrade to xen-hypervisor-3.0.3-1-i386-pae_3.0.3-0-3\n');
}
if (deb_check(prefix: 'xen-ioemu-3.0.3-1', release: '4.0', reference: '3.0.3-0-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-ioemu-3.0.3-1 is vulnerable in Debian 4.0.\nUpgrade to xen-ioemu-3.0.3-1_3.0.3-0-3\n');
}
if (deb_check(prefix: 'xen-utils-3.0.3-1', release: '4.0', reference: '3.0.3-0-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-utils-3.0.3-1 is vulnerable in Debian 4.0.\nUpgrade to xen-utils-3.0.3-1_3.0.3-0-3\n');
}
if (deb_check(prefix: 'xen-utils', release: '4.0', reference: '3.0.3-0-3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package xen-utils is vulnerable in Debian etch.\nUpgrade to xen-utils_3.0.3-0-3\n');
}
if (w) { security_hole(port: 0, data: desc); }
