# This script was automatically generated from the dsa-1387
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
It has been discovered that the original patch for a buffer overflow in
svc_auth_gss.c in the RPCSEC_GSS RPC library in MIT Kerberos 5
(CVE-2007-3999,
DSA-1368-1) was insufficient to protect from arbitrary
code execution in some environments.
The old stable distribution (sarge) does not contain a librpcseggss
package.
For the stable distribution (etch), this problem has been fixed in
version 0.14-2etch3.
For the unstable distribution (sid), this problem has been fixed in
version 0.14-4.
We recommend that you upgrade your librpcsecgss package.


Solution : http://www.debian.org/security/2007/dsa-1387
Risk factor : High';

if (description) {
 script_id(27066);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1387");
 script_cve_id("CVE-2007-4743");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1387] DSA-1387-1 librpcsecgss");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1387-1 librpcsecgss");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'librpcsecgss-dev', release: '4.0', reference: '0.14-2etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package librpcsecgss-dev is vulnerable in Debian 4.0.\nUpgrade to librpcsecgss-dev_0.14-2etch3\n');
}
if (deb_check(prefix: 'librpcsecgss3', release: '4.0', reference: '0.14-2etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package librpcsecgss3 is vulnerable in Debian 4.0.\nUpgrade to librpcsecgss3_0.14-2etch3\n');
}
if (deb_check(prefix: 'librpcsecgss', release: '4.0', reference: '0.14-2etch3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package librpcsecgss is vulnerable in Debian etch.\nUpgrade to librpcsecgss_0.14-2etch3\n');
}
if (w) { security_hole(port: 0, data: desc); }
