# This script was automatically generated from the dsa-1388
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The patch used to correct the DHCP server buffer overflow in DSA-1388-1
was incomplete and did not adequately resolve the problem.  This update
to the previous advisory makes updated packages based on a
newer version of the patch available.
For completeness, please find below the original advisory:
It was discovered that dhcp, a DHCP server for automatic IP address assignment,
didn\'t correctly allocate space for network replies.  This could potentially
allow a malicious DHCP client to execute arbitrary code upon the DHCP server.
<!-- 
For the old stable distribution (sarge), this problem has been fixed in
version 2.0pl5-19.1sarge3.
 -->

For the stable distribution (etch), this problem has been fixed in
version 2.0pl5-19.5etch2.


For the unstable distribution (sid), this problem will be fixed shortly.


Updates to the old stable version (sarge) are pending.


We recommend that you upgrade your dhcp packages.



Solution : http://www.debian.org/security/2007/dsa-1388
Risk factor : High';

if (description) {
 script_id(27515);
 script_version("$Revision: 1.5 $");
 script_xref(name: "DSA", value: "1388");
 script_cve_id("CVE-2007-5365");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1388] DSA-1388-3 dhcp");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1388-3 dhcp");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'dhcp', release: '3.1', reference: '2.0pl5-19.5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp is vulnerable in Debian 3.1.\nUpgrade to dhcp_2.0pl5-19.5etch2\n');
}
if (deb_check(prefix: 'dhcp-client', release: '3.1', reference: '2.0pl5-19.5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp-client is vulnerable in Debian 3.1.\nUpgrade to dhcp-client_2.0pl5-19.5etch2\n');
}
if (deb_check(prefix: 'dhcp-relay', release: '3.1', reference: '2.0pl5-19.5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp-relay is vulnerable in Debian 3.1.\nUpgrade to dhcp-relay_2.0pl5-19.5etch2\n');
}
if (deb_check(prefix: 'dhcp', release: '4.0', reference: '2.0pl5-19.5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp is vulnerable in Debian 4.0.\nUpgrade to dhcp_2.0pl5-19.5etch1\n');
}
if (deb_check(prefix: 'dhcp-client', release: '4.0', reference: '2.0pl5-19.5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp-client is vulnerable in Debian 4.0.\nUpgrade to dhcp-client_2.0pl5-19.5etch1\n');
}
if (deb_check(prefix: 'dhcp-relay', release: '4.0', reference: '2.0pl5-19.5etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp-relay is vulnerable in Debian 4.0.\nUpgrade to dhcp-relay_2.0pl5-19.5etch1\n');
}
if (deb_check(prefix: 'dhcp', release: '4.0', reference: '2.0pl5-19.5etch2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp is vulnerable in Debian etch.\nUpgrade to dhcp_2.0pl5-19.5etch2\n');
}
if (deb_check(prefix: 'dhcp', release: '3.1', reference: '2.0pl5-19.1sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package dhcp is vulnerable in Debian sarge.\nUpgrade to dhcp_2.0pl5-19.1sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
