# This script was automatically generated from the dsa-1396
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
# Translators: this is nearly a copy of DSA 1392

Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

    
    Michal Zalewski discovered that the unload event handler had access to
    the address of the next page to be loaded, which could allow information
    disclosure or spoofing.
    
    
    Stefano Di Paola discovered that insufficient validation of user names
    used in Digest authentication on a web site allows HTTP response splitting
    attacks.
    
    It was discovered that insecure focus handling of the file upload
    control can lead to information disclosure. This is a variant of
    CVE-2006-2894.
    
    
    Eli Friedman discovered that web pages written in Xul markup can hide the
    titlebar of windows, which can lead to spoofing attacks.
    
    
    Georgi Guninski discovered the insecure handling of smb:// and sftp:// URI
    schemes may lead to information disclosure. This vulnerability is only
    exploitable if Gnome-VFS support is present on the system.
    
    
    <q>moz_bug_r_a4</q> discovered that the protection scheme offered by XPCNativeWrappers
    could be bypassed, which might allow privilege escalation.
    
    
    L. David Baron, Boris Zbarsky, Georgi Guninski, Paul Nickerson, Olli Pettay,
    Jesse Ruderman, Vladimir Sukhoy, Daniel Veditz, and Martijn Wargers discovered
    crashes in the layout engine, which might allow the execution of arbitrary code.
    
    
    Igor Bukanov, Eli Friedman, and Jesse Ruderman discovered crashes in the
    Javascript engine, which might allow the execution of arbitrary code.

The Mozilla products in the oldstable distribution (sarge) are no longer
supported with security updates.


For the stable distribution (etch) these problems have been fixed in version
2.0.0.6+2.0.0.8-0etch1. Builds for arm and sparc will be provided later.


For the unstable distribution (sid) these problems have been fixed in version
2.0.0.8-1.


We recommend that you upgrade your iceweasel packages.



Solution : http://www.debian.org/security/2007/dsa-1396
Risk factor : High';

if (description) {
 script_id(27587);
 script_version("$Revision: 1.2 $");
 script_xref(name: "DSA", value: "1396");
 script_cve_id("CVE-2007-1095", "CVE-2007-2292", "CVE-2007-3511", "CVE-2007-5334", "CVE-2007-5337", "CVE-2007-5338", "CVE-2007-5339");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1396] DSA-1396-1 iceweasel");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1396-1 iceweasel");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'firefox', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox is vulnerable in Debian 4.0.\nUpgrade to firefox_2.0.0.6+2.0.0.8-0etch1\n');
}
if (deb_check(prefix: 'firefox-dom-inspector', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to firefox-dom-inspector_2.0.0.6+2.0.0.8-0etch1\n');
}
if (deb_check(prefix: 'firefox-gnome-support', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to firefox-gnome-support_2.0.0.6+2.0.0.8-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.6-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian 4.0.\nUpgrade to iceweasel_2.0.0.6-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dbg', release: '4.0', reference: '2.0.0.6-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dbg is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dbg_2.0.0.6-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-dom-inspector', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to iceweasel-dom-inspector_2.0.0.6+2.0.0.8-0etch1\n');
}
if (deb_check(prefix: 'iceweasel-gnome-support', release: '4.0', reference: '2.0.0.6-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel-gnome-support is vulnerable in Debian 4.0.\nUpgrade to iceweasel-gnome-support_2.0.0.6-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox_2.0.0.6+2.0.0.8-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-dom-inspector', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-dom-inspector is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-dom-inspector_2.0.0.6+2.0.0.8-0etch1\n');
}
if (deb_check(prefix: 'mozilla-firefox-gnome-support', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package mozilla-firefox-gnome-support is vulnerable in Debian 4.0.\nUpgrade to mozilla-firefox-gnome-support_2.0.0.6+2.0.0.8-0etch1\n');
}
if (deb_check(prefix: 'iceweasel', release: '4.0', reference: '2.0.0.6+2.0.0.8-0etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package iceweasel is vulnerable in Debian etch.\nUpgrade to iceweasel_2.0.0.6+2.0.0.8-0etch1\n');
}
if (w) { security_hole(port: 0, data: desc); }
