# This script was automatically generated from the dsa-1399
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '


Tavis Ormandy of the Google Security Team has discovered several
security issues in PCRE, the Perl-Compatible Regular Expression library,
which potentially allow attackers to execute arbitrary code by compiling
specially crafted regular expressions.


Version 7.0 of the PCRE library featured a major rewrite of the regular
expression compiler, and it was deemed infeasible to backport the
security fixes in version 7.3 to the versions in Debian\'s stable and
oldstable distributions (6.7 and 4.5, respectively).  Therefore, this
update is based on version 7.4 (which includes the security bug fixes of
the 7.3 version, plus several regression fixes), with special patches to
improve the compatibility with the older versions.  As a result, extra
care is necessary when applying this update.


The Common Vulnerabilities and Exposures project identifies the
following problems:

    
    Unmatched \\Q\\E sequences with orphan \\E codes can cause the compiled
    regex to become desynchronized, resulting in corrupt bytecode that may
    result in multiple exploitable conditions.
    
    
    Multiple forms of character classes had their sizes miscalculated on
    initial passes, resulting in too little memory being allocated.
    
    
    Multiple patterns of the form  \\X?\\d or \\P{L}?\\d in non-UTF-8 mode
    could backtrack before the start of the string, possibly leaking
    information from the address space, or causing a crash by reading out
    of bounds.
    
    
    A number of routines can be fooled into reading past the end of a
    string looking for unmatched parentheses or brackets, resulting in a
    denial of service.
    
    
    Multiple integer overflows in the processing of escape sequences could
    result in heap overflows or out of bounds reads/writes.
    
    
    Multiple infinite loops and heap overflows were disovered in the
    handling of \\P and \\P{x} sequences, where the length of these
    non-standard operations was mishandled.
    
    
    Character classes containing a lone unicode sequence were incorrectly
    optimised, resulting in a heap overflow.
    

For the old stable distribution (sarge), these problems have been fixed in
version 4.5+7.4-1.


For the stable distribution (etch), these problems have been fixed in
version 6.7+7.4-2.


For the unstable distribution (sid), these problems have been fixed in
version 7.3-1.



Solution : http://www.debian.org/security/2007/dsa-1399
Risk factor : High';

if (description) {
 script_id(27629);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1399");
 script_cve_id("CVE-2007-1659", "CVE-2007-1660", "CVE-2007-1661", "CVE-2007-1662", "CVE-2007-4766", "CVE-2007-4767", "CVE-2007-4768");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1399] DSA-1399-1 pcre3");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1399-1 pcre3");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libpcre3', release: '3.1', reference: '4.5+7.4-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3 is vulnerable in Debian 3.1.\nUpgrade to libpcre3_4.5+7.4-1\n');
}
if (deb_check(prefix: 'libpcre3-dev', release: '3.1', reference: '4.5+7.4-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3-dev is vulnerable in Debian 3.1.\nUpgrade to libpcre3-dev_4.5+7.4-1\n');
}
if (deb_check(prefix: 'pcregrep', release: '3.1', reference: '4.5+7.4-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcregrep is vulnerable in Debian 3.1.\nUpgrade to pcregrep_4.5+7.4-1\n');
}
if (deb_check(prefix: 'pgrep', release: '3.1', reference: '4.5+7.4-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pgrep is vulnerable in Debian 3.1.\nUpgrade to pgrep_4.5+7.4-1\n');
}
if (deb_check(prefix: 'libpcre3', release: '4.0', reference: '6.7+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3 is vulnerable in Debian 4.0.\nUpgrade to libpcre3_6.7+7.4-2\n');
}
if (deb_check(prefix: 'libpcre3-dev', release: '4.0', reference: '6.7+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcre3-dev is vulnerable in Debian 4.0.\nUpgrade to libpcre3-dev_6.7+7.4-2\n');
}
if (deb_check(prefix: 'libpcrecpp0', release: '4.0', reference: '6.7+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libpcrecpp0 is vulnerable in Debian 4.0.\nUpgrade to libpcrecpp0_6.7+7.4-2\n');
}
if (deb_check(prefix: 'pcregrep', release: '4.0', reference: '6.7+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcregrep is vulnerable in Debian 4.0.\nUpgrade to pcregrep_6.7+7.4-2\n');
}
if (deb_check(prefix: 'pcre3', release: '4.0', reference: '6.7+7.4-2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcre3 is vulnerable in Debian etch.\nUpgrade to pcre3_6.7+7.4-2\n');
}
if (deb_check(prefix: 'pcre3', release: '3.1', reference: '4.5+7.4-1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pcre3 is vulnerable in Debian sarge.\nUpgrade to pcre3_4.5+7.4-1\n');
}
if (w) { security_hole(port: 0, data: desc); }
