# This script was automatically generated from the dsa-1403
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Omer Singer of the DigiTrust Group discovered several vulnerabilities in
phpMyAdmin, an application to administrate MySQL over the WWW. The Common
Vulnerabilities and Exposures project identifies the following problems:
    phpMyAdmin allows a remote attacker to inject arbitrary web script
    or HTML in the context of a logged in user\'s session (cross site
    scripting).
    phpMyAdmin, when accessed by a browser that does not URL-encode
    requests, allows remote attackers to inject arbitrary web script
    or HTML via the query string.
For the old stable distribution (sarge) this problem has been fixed in
version 4:2.6.2-3sarge6.
For the stable distribution (etch) this problem has been fixed in
version 4:2.9.1.1-6.
For the unstable distribution (sid) this problem has been fixed in
version 4:2.11.1.2-1.
We recommend that you upgrade your phpmyadmin package.


Solution : http://www.debian.org/security/2007/dsa-1403
Risk factor : High';

if (description) {
 script_id(27842);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1403");
 script_cve_id("CVE-2007-5386", "CVE-2007-5589");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1403] DSA-1403-1 phpmyadmin");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1403-1 phpmyadmin");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'phpmyadmin', release: '3.1', reference: '2.6.2-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpmyadmin is vulnerable in Debian 3.1.\nUpgrade to phpmyadmin_2.6.2-3sarge6\n');
}
if (deb_check(prefix: 'phpmyadmin', release: '4.0', reference: '2.9.1.1-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpmyadmin is vulnerable in Debian 4.0.\nUpgrade to phpmyadmin_2.9.1.1-6\n');
}
if (deb_check(prefix: 'phpmyadmin', release: '4.0', reference: '2.9.1.1-6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpmyadmin is vulnerable in Debian etch.\nUpgrade to phpmyadmin_2.9.1.1-6\n');
}
if (deb_check(prefix: 'phpmyadmin', release: '3.1', reference: '2.6.2-3sarge6')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpmyadmin is vulnerable in Debian sarge.\nUpgrade to phpmyadmin_2.6.2-3sarge6\n');
}
if (w) { security_hole(port: 0, data: desc); }
