# This script was automatically generated from the dsa-1411
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several vulnerabilities have been discovered in Ruby, an object-oriented
scripting language. The Common Vulnerabilities and Exposures project
identifies the following problems:
    It was discovered that the Ruby HTTP(S) module performs insufficient
    validation of SSL certificates, which may lead to man-in-the-middle
    attacks.
    It was discovered that the Ruby modules for FTP, Telnet, IMAP, POP
    and SMTP perform insufficient validation of SSL certificates, which
    may lead to man-in-the-middle attacks.
For the old stable distribution (sarge) these problems have been fixed
in version 0.1.4a-1sarge1. Packages for sparc will be provided later.
The stable distribution (etch) no longer contains libopenssl-ruby.
We recommend that you upgrade your libopenssl-ruby packages.


Solution : http://www.debian.org/security/2007/dsa-1411
Risk factor : High';

if (description) {
 script_id(28300);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1411");
 script_cve_id("CVE-2007-5162", "CVE-2007-5770");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1411] DSA-1411-1 libopenssl-ruby");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1411-1 libopenssl-ruby");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libopenssl-ruby1.6', release: '3.1', reference: '0.1.4a-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libopenssl-ruby1.6 is vulnerable in Debian 3.1.\nUpgrade to libopenssl-ruby1.6_0.1.4a-1sarge1\n');
}
if (deb_check(prefix: 'libopenssl-ruby', release: '3.1', reference: '0.1.4a-1sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libopenssl-ruby is vulnerable in Debian sarge.\nUpgrade to libopenssl-ruby_0.1.4a-1sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
