# This script was automatically generated from the dsa-1419
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
A vulnerability has been discovered in HSQLDB, the default database
engine shipped with OpenOffice.org.  This could result in the
execution of arbitrary Java code embedded in a OpenOffice.org database
document with the user\'s privilege.  This update requires an update of
both openoffice.org and hsqldb.
The old stable distribution (sarge) is not affected by this problem.
For the stable distribution (etch) this problem has been fixed in
version 2.0.4.dfsg.2-7etch4 of OpenOffice.org and in version
1.8.0.7-1etch1 of hsqldb.
For the unstable distribution (sid) this problem has been fixed in
version 2.3.1-1 of OpenOffice.org and in version 1.8.0.9-2 of hsqldb.
For the experimental distribution this problem has been fixed in
version 2.3.1~rc1-1 of OpenOffice.org and in version 1.8.0.9-1 of
hsqldb.
We recommend that you upgrade your OpenOffice.org and hsqldb packages.


Solution : http://www.debian.org/security/2007/dsa-1419
Risk factor : High';

if (description) {
 script_id(29226);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1419");
 script_cve_id("CVE-2007-4575");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1419] DSA-1419-1 openoffice.org");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1419-1 openoffice.org");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'broffice.org', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package broffice.org is vulnerable in Debian 4.0.\nUpgrade to broffice.org_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'hsqldb-server', release: '4.0', reference: '1.8.0.7-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package hsqldb-server is vulnerable in Debian 4.0.\nUpgrade to hsqldb-server_1.8.0.7-1etch1\n');
}
if (deb_check(prefix: 'libhsqldb-java', release: '4.0', reference: '1.8.0.7-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libhsqldb-java is vulnerable in Debian 4.0.\nUpgrade to libhsqldb-java_1.8.0.7-1etch1\n');
}
if (deb_check(prefix: 'libhsqldb-java-doc', release: '4.0', reference: '1.8.0.7-1etch1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libhsqldb-java-doc is vulnerable in Debian 4.0.\nUpgrade to libhsqldb-java-doc_1.8.0.7-1etch1\n');
}
if (deb_check(prefix: 'libmythes-dev', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libmythes-dev is vulnerable in Debian 4.0.\nUpgrade to libmythes-dev_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org is vulnerable in Debian 4.0.\nUpgrade to openoffice.org_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-base', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-base is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-base_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-calc', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-calc is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-calc_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-common', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-common is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-common_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-core', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-core is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-core_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-dbg', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-dbg is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-dbg_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-dev', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-dev is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-dev_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-dev-doc', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-dev-doc is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-dev-doc_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-draw', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-draw is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-draw_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-dtd-officedocument1.0', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-dtd-officedocument1.0 is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-dtd-officedocument1.0_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-evolution', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-evolution is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-evolution_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-filter-mobiledev', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-filter-mobiledev is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-filter-mobiledev_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-filter-so52', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-filter-so52 is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-filter-so52_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-gcj', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-gcj is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-gcj_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-gnome', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-gnome is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-gnome_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-gtk', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-gtk is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-gtk_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-gtk-gnome', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-gtk-gnome is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-gtk-gnome_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-cs', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-cs is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-cs_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-da', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-da is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-da_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-de', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-de is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-de_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-dz', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-dz is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-dz_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-en', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-en is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-en_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-en-gb', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-en-gb is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-en-gb_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-en-us', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-en-us is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-en-us_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-es', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-es is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-es_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-et', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-et is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-et_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-fr', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-fr is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-fr_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-hi-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-hi-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-hi-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-hu', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-hu is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-hu_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-it', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-it is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-it_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-ja', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-ja is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-ja_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-km', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-km is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-km_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-ko', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-ko is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-ko_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-nl', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-nl is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-nl_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-pl', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-pl is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-pl_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-pt-br', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-pt-br is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-pt-br_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-ru', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-ru is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-ru_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-sl', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-sl is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-sl_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-sv', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-sv is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-sv_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-zh-cn', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-zh-cn is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-zh-cn_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-help-zh-tw', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-help-zh-tw is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-help-zh-tw_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-impress', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-impress is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-impress_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-java-common', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-java-common is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-java-common_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-kde', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-kde is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-kde_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-af', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-af is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-af_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-as-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-as-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-as-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-be-by', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-be-by is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-be-by_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-bg', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-bg is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-bg_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-bn', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-bn is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-bn_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-br', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-br is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-br_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-bs', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-bs is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-bs_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ca', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ca is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ca_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-cs', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-cs is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-cs_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-cy', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-cy is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-cy_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-da', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-da is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-da_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-de', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-de is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-de_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-dz', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-dz is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-dz_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-el', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-el is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-el_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-en-gb', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-en-gb is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-en-gb_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-en-za', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-en-za is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-en-za_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-eo', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-eo is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-eo_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-es', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-es is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-es_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-et', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-et is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-et_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-fa', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-fa is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-fa_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-fi', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-fi is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-fi_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-fr', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-fr is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-fr_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ga', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ga is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ga_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-gu-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-gu-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-gu-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-he', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-he is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-he_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-hi', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-hi is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-hi_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-hi-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-hi-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-hi-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-hr', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-hr is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-hr_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-hu', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-hu is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-hu_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-it', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-it is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-it_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ja', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ja is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ja_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ka', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ka is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ka_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-km', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-km is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-km_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ko', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ko is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ko_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ku', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ku is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ku_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-lo', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-lo is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-lo_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-lt', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-lt is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-lt_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-lv', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-lv is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-lv_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-mk', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-mk is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-mk_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ml-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ml-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ml-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-nb', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-nb is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-nb_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ne', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ne is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ne_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-nl', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-nl is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-nl_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-nn', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-nn is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-nn_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-nr', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-nr is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-nr_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ns', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ns is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ns_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-or-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-or-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-or-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-pa-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-pa-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-pa-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-pl', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-pl is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-pl_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-pt', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-pt is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-pt_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-pt-br', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-pt-br is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-pt-br_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ru', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ru is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ru_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-rw', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-rw is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-rw_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-sk', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-sk is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-sk_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-sl', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-sl is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-sl_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-sr-cs', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-sr-cs is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-sr-cs_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ss', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ss is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ss_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-st', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-st is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-st_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-sv', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-sv is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-sv_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ta-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ta-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ta-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-te-in', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-te-in is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-te-in_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-tg', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-tg is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-tg_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-th', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-th is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-th_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-tn', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-tn is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-tn_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-tr', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-tr is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-tr_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ts', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ts is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ts_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-uk', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-uk is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-uk_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-ve', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-ve is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-ve_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-vi', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-vi is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-vi_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-xh', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-xh is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-xh_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-za', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-za is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-za_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-zh-cn', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-zh-cn is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-zh-cn_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-zh-tw', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-zh-tw is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-zh-tw_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-l10n-zu', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-l10n-zu is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-l10n-zu_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-math', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-math is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-math_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-officebean', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-officebean is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-officebean_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-qa-api-tests', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-qa-api-tests is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-qa-api-tests_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-qa-tools', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-qa-tools is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-qa-tools_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org-writer', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org-writer is vulnerable in Debian 4.0.\nUpgrade to openoffice.org-writer_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'python-uno', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package python-uno is vulnerable in Debian 4.0.\nUpgrade to python-uno_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'ttf-opensymbol', release: '4.0', reference: '2.0.4.dfsg.2-7etch4')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package ttf-opensymbol is vulnerable in Debian 4.0.\nUpgrade to ttf-opensymbol_2.0.4.dfsg.2-7etch4\n');
}
if (deb_check(prefix: 'openoffice.org,', release: '4.0', reference: '2.0.4.dfsg')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package openoffice.org, is vulnerable in Debian etch.\nUpgrade to openoffice.org,_2.0.4.dfsg\n');
}
if (w) { security_hole(port: 0, data: desc); }
